/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.io.File;
import phex.ServiceManager;
import phex.share.FileAdministration;
import phex.utils.StrUtil;

public class ShareFile {
    private static final String PHEX_FILE_NAME = StrUtil.getAppNameVersion();
    private int mFileIndex;
    private FileAdministration shareFileAdmin;
    private File file;
    private String fileName;
    private char[] searchCompareTerm;
    private Long fileSize;
    private Integer searchCount;
    private Integer uploadCount;

    private ShareFile() {
    }

    public ShareFile(File file) {
        this.file = file;
        if (this.file == null) {
            this.mFileIndex = -1;
            this.fileName = PHEX_FILE_NAME;
            this.fileSize = new Long(0L);
        } else {
            this.shareFileAdmin = ServiceManager.getShareManager().getFileAdministration();
            this.searchCount = new Integer(0);
            this.uploadCount = new Integer(0);
            this.fileName = this.file.getName();
            this.searchCompareTerm = this.file.getAbsolutePath().toLowerCase().toCharArray();
            this.fileSize = new Long(this.file.length());
        }
    }

    public File getFile() {
        return this.file;
    }

    public int getFileIndex() {
        return this.mFileIndex;
    }

    public void setFileIndex(int n) {
        this.mFileIndex = n;
    }

    public Long getFileSizeObject() {
        return this.fileSize;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public Integer getSearchCountObject() {
        return this.searchCount;
    }

    public int getSearchCount() {
        return this.searchCount;
    }

    public void incSearchCount() {
        this.searchCount = new Integer(this.searchCount + 1);
        this.shareFileAdmin.fireSharedFileChanged(this);
    }

    public Integer getUploadCountObject() {
        return this.uploadCount;
    }

    public int getUploadCount() {
        return this.uploadCount;
    }

    public void incUploadCount() {
        this.uploadCount = new Integer(this.uploadCount + 1);
        this.shareFileAdmin.fireSharedFileChanged(this);
    }

    public String getEffectiveName() {
        return this.fileName;
    }

    public char[] getSearchCompareTerm() {
        return this.searchCompareTerm;
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(super.toString()))).append(this.fileName).append("  ").append(this.mFileIndex)));
    }
}

