/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import phex.HttpRange;
import phex.Res;
import phex.ServiceManager;
import phex.connection.ConnectionRequest;
import phex.host.Host;
import phex.host.HostManager;
import phex.msg.GETRequest;
import phex.share.FileAdministration;
import phex.share.MimeTypeMapping;
import phex.share.ShareFile;
import phex.share.UploadFile;
import phex.share.UploadFileContainer;
import phex.utils.IOUtil;
import phex.utils.SearchEngine;
import phex.utils.StatisticTracker;
import phex.utils.StrUtil;
import phex.utils.ThrottleController;
import phex.utils.URLUtil;

public class ShareManager {
    private static final ShareFile[] VERSION_FILE_ARRAY = new ShareFile[]{new ShareFile(null)};
    private static final String PHEX_PING = "!`phex~~ping";
    private FileAdministration fileAdministration = new FileAdministration(this);
    private UploadFileContainer uploadFileContainer = new UploadFileContainer();

    public boolean isHostBusy() {
        return this.uploadFileContainer.getUploadFileCount() >= ServiceManager.sCfg.mMaxUpload;
    }

    public FileAdministration getFileAdministration() {
        return this.fileAdministration;
    }

    public UploadFileContainer getUploadFileContainer() {
        return this.uploadFileContainer;
    }

    public void addUploadFile(UploadFile uploadFile) {
        this.uploadFileContainer.addUploadFile(uploadFile);
    }

    public ShareFile[] searchFile(String string) {
        ShareFile shareFile;
        int n;
        if (ServiceManager.sCfg.mPhexPingResponse && string.equals(PHEX_PING)) {
            return VERSION_FILE_ARRAY;
        }
        String[] stringArray = new String[10];
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (n2 < 10 && stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() < 2) continue;
            stringArray[n2++] = string2.toLowerCase();
        }
        ShareFile[] shareFileArray = this.fileAdministration.getSharedFiles();
        if (n2 == 0) {
            if (string.equals("    ")) {
                ServiceManager.log("Index query detected.");
                return shareFileArray;
            }
            return new ShareFile[0];
        }
        HashMap hashMap = new HashMap();
        SearchEngine searchEngine = new SearchEngine();
        ArrayList<ShareFile> arrayList = new ArrayList<ShareFile>();
        arrayList.addAll(Arrays.asList(shareFileArray));
        for (int i = 0; i < n2 && arrayList.size() > 0; ++i) {
            searchEngine.setPattern(stringArray[i], true);
            for (n = arrayList.size() - 1; n >= 0; --n) {
                shareFile = (ShareFile)arrayList.get(n);
                searchEngine.setText(shareFile.getSearchCompareTerm(), true);
                if (searchEngine.match()) continue;
                arrayList.remove(n);
            }
        }
        if (arrayList.size() > ServiceManager.sCfg.mUploadMaxSearch) {
            ((AbstractList)arrayList).subList(ServiceManager.sCfg.mUploadMaxSearch - 1, arrayList.size() - 1).clear();
        }
        ShareFile[] shareFileArray2 = new ShareFile[arrayList.size()];
        shareFileArray2 = arrayList.toArray(shareFileArray2);
        for (n = 0; n < shareFileArray2.length; ++n) {
            shareFile = shareFileArray2[n];
            shareFile.incSearchCount();
        }
        return shareFileArray2;
    }

    public void httpRequestHandler(ConnectionRequest connectionRequest, Host host) {
        if (!connectionRequest.readHeaders(host.getIs())) {
            return;
        }
        if (connectionRequest.getUri().equals("/")) {
            this.sendFile(connectionRequest, host);
            return;
        }
        GETRequest gETRequest = new GETRequest(connectionRequest.getUri());
        if (!gETRequest.getOperation().toLowerCase().equals("get")) {
            this.sendFile(connectionRequest, host);
            return;
        }
        ShareFile shareFile = null;
        if (gETRequest.getFileIndex() != -1 && (shareFile = this.fileAdministration.getFileByIndex(gETRequest.getFileIndex())) != null) {
            File file = shareFile.getFile();
            if (!gETRequest.getFileName().equalsIgnoreCase(shareFile.getEffectiveName())) {
                shareFile = null;
            }
        }
        if (shareFile == null && (shareFile = this.fileAdministration.getFileByName(gETRequest.getFileName())) == null) {
            this.sendString(host, this.buildErrorHTTP("404 Not Found", "File not found"));
            return;
        }
        if (this.upload(connectionRequest, host, shareFile.getFile(), true)) {
            shareFile.incUploadCount();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean upload(ConnectionRequest connectionRequest, Host host, File file, boolean bl) {
        boolean bl2;
        RandomAccessFile randomAccessFile;
        block29: {
            ThrottleController throttleController;
            block28: {
                boolean bl3;
                block27: {
                    boolean bl4;
                    block26: {
                        boolean bl5;
                        block25: {
                            if (!bl) {
                                System.out.println(String.valueOf(String.valueOf(new StringBuffer("NON Gnutella net upload: ").append(host).append("  ").append(file.getName()))));
                            }
                            randomAccessFile = null;
                            UploadFile uploadFile = null;
                            HostManager hostManager = ServiceManager.getHostManager();
                            bl2 = false;
                            throttleController = ThrottleController.acquireThrottle();
                            try {
                                try {
                                    int n;
                                    HttpRange httpRange;
                                    ShareManager shareManager = this;
                                    synchronized (shareManager) {
                                        if (this.uploadFileContainer.getUploadFileCount() >= ServiceManager.sCfg.mMaxUpload) {
                                            host.log("Upload request: upload limit reached.");
                                            this.sendString(host, this.buildErrorHTTP("503 Service Unavailable", "Server busy.  Too many downloads from this host."));
                                            bl5 = bl2;
                                            // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 4, 24] lbl17 : MonitorExitStatement: MONITOREXIT : var13_10
                                            Object var25_13 = null;
                                            break block25;
                                        }
                                        int n2 = this.uploadFileContainer.getUploadCountPerIP(host.getHostAddress().getHostName());
                                        if (n2 >= ServiceManager.sCfg.mMaxUploadPerIP) {
                                            host.log("Upload request: upload limit per host reached.");
                                            this.sendString(host, this.buildErrorHTTP("503 Service Unavailable", "You have too many downloads from this host."));
                                            bl4 = bl2;
                                            // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 4, 23] lbl26 : MonitorExitStatement: MONITOREXIT : var13_10
                                            break block26;
                                        }
                                        httpRange = new HttpRange((int)file.length());
                                        String string = connectionRequest.getHeader("RANGE");
                                        if (string != null) {
                                            if (!httpRange.deserialize(string)) {
                                                host.log("Upload request: Invalid range value in partial get.  ".concat(String.valueOf(String.valueOf(string))));
                                                this.sendString(host, this.buildErrorHTTP("416 Requested Range Not Satisfiable", "Upload request: Invalid range value in partial get.  ".concat(String.valueOf(String.valueOf(string)))));
                                                bl3 = bl2;
                                                // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 4, 20, 22] lbl36 : MonitorExitStatement: MONITOREXIT : var13_10
                                                break block27;
                                            }
                                            if (httpRange.getSpecCount() == 0) {
                                                httpRange.addSpec(0, (int)file.length() - 1);
                                            }
                                        } else {
                                            httpRange.addSpec(0, (int)file.length() - 1);
                                        }
                                        n = httpRange.getLastPos() - httpRange.getFirstPos() + 1;
                                        uploadFile = new UploadFile(file, host, n, connectionRequest.getHeader("USER-AGENT"));
                                        uploadFile.setStatus(3);
                                        uploadFile.setStartingTime(System.currentTimeMillis());
                                        this.addUploadFile(uploadFile);
                                    }
                                    byte[] byArray = new byte[512];
                                    StringBuffer stringBuffer = new StringBuffer();
                                    String string = "application/binary";
                                    if (!bl) {
                                        String string2 = StrUtil.getFileExt(uploadFile.getFilename());
                                        string = MimeTypeMapping.getMimeTypeForExtension(string2);
                                    }
                                    if (n == httpRange.getEntitySize()) {
                                        stringBuffer.append("HTTP/1.1 200 OK\r\n");
                                    } else if (bl) {
                                        stringBuffer.append("HTTP/1.1 200 OK\r\n");
                                    } else {
                                        stringBuffer.append("HTTP/1.1 206 OK\r\n");
                                    }
                                    stringBuffer.append("Server: ");
                                    stringBuffer.append(StrUtil.getAppNameVersion());
                                    stringBuffer.append("\r\n");
                                    stringBuffer.append("Accept-Ranges: bytes\r\n");
                                    stringBuffer.append("Connection: close\r\n");
                                    stringBuffer.append("Content-Type: ");
                                    stringBuffer.append(string);
                                    stringBuffer.append("\r\n");
                                    if (n == httpRange.getEntitySize()) {
                                        stringBuffer.append("Content-length: ");
                                        stringBuffer.append(httpRange.getEntitySize());
                                        stringBuffer.append("\r\n");
                                    } else {
                                        stringBuffer.append("Content-range:bytes ");
                                        stringBuffer.append(httpRange.getFirstPos());
                                        stringBuffer.append("-");
                                        stringBuffer.append(httpRange.getLastPos());
                                        stringBuffer.append("/");
                                        stringBuffer.append(httpRange.getEntitySize());
                                        stringBuffer.append("\r\n");
                                        stringBuffer.append("Content-length: ");
                                        stringBuffer.append(n);
                                        stringBuffer.append("\r\n");
                                    }
                                    stringBuffer.append("\r\n");
                                    int n3 = IOUtil.serializeString(stringBuffer.toString(), byArray, 0);
                                    OutputStream outputStream = host.getOs();
                                    outputStream.write(byArray, 0, n3);
                                    randomAccessFile = new RandomAccessFile(file, "r");
                                    randomAccessFile.seek(httpRange.getFirstPos());
                                    long l = 0L;
                                    while (n > 0 && (n3 = randomAccessFile.read(byArray)) != -1) {
                                        outputStream.write(byArray, 0, n3);
                                        n -= n3;
                                        uploadFile.setTransferredDataSize(l += (long)n3);
                                        throttleController.setRate(ServiceManager.sCfg.mUploadMaxBandwidth / this.uploadFileContainer.getUploadFileCount());
                                        throttleController.controlThrottle(n3);
                                    }
                                    uploadFile.setTransferredDataSize(l);
                                    uploadFile.setStatus(4);
                                    uploadFile.setStoppingTime(System.currentTimeMillis());
                                    StatisticTracker statisticTracker = ServiceManager.getStatisticTracker();
                                    statisticTracker.incStatUploadCount(1);
                                    bl2 = true;
                                    Thread.sleep(2000L);
                                    break block28;
                                }
                                catch (Exception exception) {
                                    bl2 = false;
                                    if (uploadFile != null && uploadFile.getStatus() != 6) {
                                        uploadFile.setStatus(5, exception.getMessage());
                                        uploadFile.setStoppingTime(System.currentTimeMillis());
                                    }
                                    Object var25_17 = null;
                                    ThrottleController.releaseThrottle(throttleController);
                                    throttleController = null;
                                    break block29;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var25_18 = null;
                                ThrottleController.releaseThrottle(throttleController);
                                throttleController = null;
                                throw throwable;
                            }
                        }
                        ThrottleController.releaseThrottle(throttleController);
                        return bl5;
                    }
                    Object var25_14 = null;
                    ThrottleController.releaseThrottle(throttleController);
                    return bl4;
                }
                Object var25_15 = null;
                ThrottleController.releaseThrottle(throttleController);
                return bl3;
            }
            Object var25_16 = null;
            ThrottleController.releaseThrottle(throttleController);
            throttleController = null;
        }
        if (randomAccessFile == null) return bl2;
        try {
            randomAccessFile.close();
            return bl2;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl2;
    }

    private void sendFile(ConnectionRequest connectionRequest, Host host) {
        String string;
        try {
            string = URLUtil.decodeURL(connectionRequest.getUri());
        }
        catch (Exception exception) {
            host.log("Invalid URI from client.  ".concat(String.valueOf(String.valueOf(connectionRequest.getUri()))));
            this.sendString(host, this.buildErrorHTTP("400 Bad Request", "Invalid URI from client.  ".concat(String.valueOf(String.valueOf(connectionRequest.getUri())))));
            return;
        }
        if (string.indexOf("..") != -1) {
            host.log("Invalid URI from client, containing '..'  ".concat(String.valueOf(String.valueOf(connectionRequest.getUri()))));
            this.sendString(host, this.buildErrorHTTP("400 Bad Request", "Invalid URI from client.  ".concat(String.valueOf(String.valueOf(connectionRequest.getUri())))));
            return;
        }
        Object[] objectArray = this.fileAdministration.getSharedDirectories();
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = (String)objectArray[i];
            File file = new File(string2);
            String string3 = StrUtil.replaceAllChar(string, '/', File.separator);
            String string4 = String.valueOf(String.valueOf(file.getAbsolutePath())).concat(String.valueOf(String.valueOf(string3)));
            File file2 = new File(string4);
            if (!file2.exists()) continue;
            if (!file2.isFile()) {
                File file3 = new File(file2, "index.html");
                if (file3.exists()) {
                    this.upload(connectionRequest, host, file3, false);
                    return;
                }
                file3 = new File(file2, "Index.html");
                if (file3.exists()) {
                    this.upload(connectionRequest, host, file3, false);
                    return;
                }
                file3 = new File(file2, "default.html");
                if (file3.exists()) {
                    this.upload(connectionRequest, host, file3, false);
                    return;
                }
                file3 = new File(file2, "Default.html");
                if (file3.exists()) {
                    this.upload(connectionRequest, host, file3, false);
                    return;
                }
                if (!ServiceManager.sCfg.mShareBrowseDir) {
                    this.sendString(host, this.buildErrorHTTP("403 Forbidden", "Directory browsing is not allowed."));
                } else {
                    this.sendString(host, this.buildDirListHTTP(file2, string));
                }
                return;
            }
            ShareFile shareFile = this.fileAdministration.getFileByName(file2.getAbsolutePath());
            if (shareFile != null) {
                File file4 = shareFile.getFile();
                if (this.upload(connectionRequest, host, file4, false)) {
                    shareFile.incUploadCount();
                }
            } else {
                this.sendString(host, this.buildErrorHTTP("404 Not Found", "File not found."));
            }
            return;
        }
        this.sendString(host, this.buildErrorHTTP("404 Not Found", "File not found."));
    }

    private void sendString(Host host, String string) {
        try {
            int n;
            byte[] byArray = new byte[string.length()];
            int n2 = IOUtil.serializeString(string, byArray, 0);
            OutputStream outputStream = host.getOs();
            HostManager hostManager = ServiceManager.getHostManager();
            StatisticTracker statisticTracker = ServiceManager.getStatisticTracker();
            for (int i = 0; i < n2; i += n) {
                n = n2 - i;
                if (n > 1024) {
                    n = 1024;
                }
                outputStream.write(byArray, i, n);
                statisticTracker.incBytesCount(n);
                hostManager.throttleControl(n);
            }
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String buildDirListHTTP(File file, String string) {
        String string2;
        File[] fileArray;
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd KK:mma");
        stringBuffer.append("HTTP/1.1 200 OK\r\n");
        stringBuffer.append(String.valueOf(String.valueOf(new StringBuffer("Server: ").append(StrUtil.getAppNameVersion()).append("\r\n"))));
        stringBuffer.append("Content-Type: text/html\r\n");
        stringBuffer.append("Connection: close\r\n");
        stringBuffer2.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">");
        stringBuffer2.append("<HTML>");
        stringBuffer2.append(String.valueOf(String.valueOf(new StringBuffer("<HEAD><TITLE>Index of ").append(string).append("</TITLE></HEAD>"))));
        stringBuffer2.append("<BODY>");
        stringBuffer2.append(String.valueOf(String.valueOf(new StringBuffer("<H3>Index of ").append(string).append("</H3>\n"))));
        stringBuffer2.append("<PRE>");
        stringBuffer2.append("Name                                   Last Modified           Size       Bytes\n");
        stringBuffer2.append("<HR>");
        if (string.startsWith("/") && string.length() > 1) {
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            n = string.lastIndexOf("/");
            string = string.substring(0, n + 1);
            object = URLUtil.encodeURL(string);
            stringBuffer2.append(String.valueOf(String.valueOf(new StringBuffer("[<A HREF=\"").append((String)object).append("\">Parent Directory</A>]\n"))));
            fileArray = file.listFiles();
        } else {
            int n2;
            ArrayList<File> arrayList = new ArrayList<File>();
            object = this.fileAdministration.getSharedDirectories();
            for (n2 = 0; n2 < ((Object[])object).length; ++n2) {
                string2 = (String)object[n2];
                fileArray = new File(string2).listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    arrayList.add(fileArray[i]);
                }
            }
            fileArray = new File[arrayList.size()];
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                fileArray[n2] = (File)arrayList.get(n2);
            }
        }
        for (n = 0; n < fileArray.length; ++n) {
            if (this.fileAdministration.isFileInvalid(fileArray[n])) continue;
            object = fileArray[n].getName();
            if (!fileArray[n].isFile()) {
                object = String.valueOf(String.valueOf(object)).concat("/");
            }
            String string3 = URLUtil.encodeURL((String)object);
            string2 = StrUtil.getPadStr((String)object, 39);
            StringBuffer stringBuffer3 = new StringBuffer(string2);
            StrUtil.replaceAllChar(stringBuffer3, '&', "&amp;");
            StrUtil.replaceAllChar(stringBuffer3, '\"', "&quot;");
            StrUtil.replaceAllChar(stringBuffer3, '<', "&lt;");
            StrUtil.replaceAllChar(stringBuffer3, '>', "&gt;");
            String string4 = String.valueOf(String.valueOf(new StringBuffer("<A HREF=\"").append(string3).append("\">").append((String)object).append("</A>").append((Object)stringBuffer3)));
            stringBuffer2.append(string4);
            String string5 = simpleDateFormat.format(new Date(fileArray[n].lastModified()));
            stringBuffer2.append(StrUtil.padStringRight(string5, 19));
            String string6 = fileArray[n].isFile() ? StrUtil.formatSizeBytes(fileArray[n].length()) : "-";
            stringBuffer2.append(StrUtil.padStringLeft(string6, 9));
            string6 = fileArray[n].isFile() ? String.valueOf(fileArray[n].length()) : "-";
            stringBuffer2.append(StrUtil.padStringLeft(string6, 12));
            stringBuffer2.append("\n");
        }
        stringBuffer2.append("<HR>");
        stringBuffer2.append("Powered by ");
        stringBuffer2.append(StrUtil.getAppNameVersion());
        stringBuffer2.append("\r\n<A HREF=\"");
        stringBuffer2.append(Res.getStr("Program.Url"));
        stringBuffer2.append("\">");
        stringBuffer2.append(Res.getStr("Program.Url"));
        stringBuffer2.append("</A>\r\n");
        stringBuffer2.append("</PRE>");
        stringBuffer2.append("</BODY>");
        stringBuffer2.append("</HTML>");
        stringBuffer.append(String.valueOf(String.valueOf(new StringBuffer("Content-Length: ").append(stringBuffer2.length()).append("\r\n"))));
        stringBuffer.append("\r\n");
        stringBuffer.append((Object)stringBuffer2);
        return stringBuffer.toString();
    }

    private String buildErrorHTTP(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(String.valueOf(new StringBuffer("HTTP/1.1 ").append(string).append("\r\n"))));
        stringBuffer.append(String.valueOf(String.valueOf(new StringBuffer("Server: ").append(StrUtil.getAppNameVersion()).append("\r\n"))));
        stringBuffer.append("Connection: close\r\n");
        stringBuffer.append("Content-Tyep: text/plain\r\n");
        stringBuffer.append(String.valueOf(String.valueOf(new StringBuffer("Content-Length: ").append(string2.length()).append("\r\n"))));
        stringBuffer.append("\r\n");
        stringBuffer.append("<html><head><title>PHEX</title></head><body>");
        stringBuffer.append(string2);
        stringBuffer.append("<hr>Visit the Phex website at ");
        stringBuffer.append("<a href=\"http://phex.sourceforge.net\">http://phex.sourceforge.net</a>.");
        stringBuffer.append("</body>");
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }
}

