/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import phex.ServiceManager;
import phex.common.TransferRateService;
import phex.event.UploadFilesChangeListener;
import phex.share.UploadFile;

public class UploadFileContainer {
    private ArrayList listenerList = new ArrayList(2);
    private ArrayList uploadFileList = new ArrayList();
    private TransferRateService transferRateService = ServiceManager.getTransferRateService();

    public synchronized int getUploadListSize() {
        return this.uploadFileList.size();
    }

    public synchronized int getUploadFileCount() {
        int n = 0;
        for (int i = this.uploadFileList.size() - 1; i >= 0; --i) {
            UploadFile uploadFile = (UploadFile)this.uploadFileList.get(i);
            if (uploadFile.getStatus() != 3) continue;
            ++n;
        }
        return n;
    }

    public synchronized UploadFile getUploadFileAt(int n) {
        return (UploadFile)this.uploadFileList.get(n);
    }

    public synchronized void addUploadFile(UploadFile uploadFile) {
        int n = this.uploadFileList.size();
        this.uploadFileList.add(n, uploadFile);
        this.transferRateService.registerTransferDataProvider(uploadFile);
        this.fireUploadFileAdded(n);
    }

    public synchronized int getUploadCountPerIP(String string) {
        int n = 0;
        Iterator iterator = ((AbstractList)this.uploadFileList).iterator();
        while (iterator.hasNext()) {
            UploadFile uploadFile = (UploadFile)iterator.next();
            if (uploadFile.getStatus() != 3 || !uploadFile.getRemoteHost().getHostAddress().getHostName().equals(string)) continue;
            ++n;
        }
        return n;
    }

    public synchronized void cleanUploadFileList() {
        for (int i = this.uploadFileList.size() - 1; i >= 0; --i) {
            UploadFile uploadFile = (UploadFile)this.uploadFileList.get(i);
            if (uploadFile.getStatus() == 1 || uploadFile.getStatus() == 3) continue;
            this.transferRateService.unregisterTransferDataProvider(uploadFile);
            this.uploadFileList.remove(i);
            this.fireUploadFileRemoved(i);
        }
    }

    public void addUploadFilesChangeListener(UploadFilesChangeListener uploadFilesChangeListener) {
        this.listenerList.add(uploadFilesChangeListener);
    }

    public void removeUploadFilesChangeListener(UploadFilesChangeListener uploadFilesChangeListener) {
        ((AbstractCollection)this.listenerList).remove(uploadFilesChangeListener);
    }

    private void fireUploadFileChanged(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = UploadFileContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    UploadFilesChangeListener uploadFilesChangeListener = (UploadFilesChangeListener)objectArray[i];
                    uploadFilesChangeListener.uploadFileChanged(n);
                }
            }
        });
    }

    private void fireUploadFileAdded(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = UploadFileContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    UploadFilesChangeListener uploadFilesChangeListener = (UploadFilesChangeListener)objectArray[i];
                    uploadFilesChangeListener.uploadFileAdded(n);
                }
            }
        });
    }

    private void fireUploadFileRemoved(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = UploadFileContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    UploadFilesChangeListener uploadFilesChangeListener = (UploadFilesChangeListener)objectArray[i];
                    uploadFilesChangeListener.uploadFileRemoved(n);
                }
            }
        });
    }

    public void fireUploadFileChanged(UploadFile uploadFile) {
        int n = this.uploadFileList.indexOf(uploadFile);
        if (n >= 0) {
            this.fireUploadFileChanged(n);
        }
    }
}

