/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;

public class IOUtil {
    public static int serializeIntLE(int n, byte[] byArray, int n2) {
        byArray[n2++] = (byte)n;
        byArray[n2++] = (byte)(n >> 8);
        byArray[n2++] = (byte)(n >> 16);
        byArray[n2++] = (byte)(n >> 24);
        return n2;
    }

    public static int deserializeIntLE(byte[] byArray, int n) {
        return byArray[n + 3] << 24 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    public static int serializeShortLE(short s, byte[] byArray, int n) {
        byArray[n++] = (byte)s;
        byArray[n++] = (byte)(s >> 8);
        return n;
    }

    public static short deserializeShortLE(byte[] byArray, int n) {
        return (short)((byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF);
    }

    public static int unsignedByte2int(byte by) {
        return by & 0xFF;
    }

    public static int serializeString(String string, byte[] byArray, int n) {
        for (int i = 0; i < string.length(); ++i) {
            byArray[n] = (byte)string.charAt(i);
            ++n;
        }
        return n;
    }

    public static int deserializeString(byte[] byArray, int n, StringBuffer stringBuffer) {
        int n2 = n;
        int n3 = byArray.length;
        while (n < n3 && byArray[n] != 0) {
            ++n;
        }
        if (n - n2 > 0) {
            stringBuffer.append(new String(byArray, n2, n - n2));
        }
        return n;
    }

    public static int deserializeString(byte[] byArray, int n, int n2, StringBuffer stringBuffer) {
        if (n2 > byArray.length - n) {
            n2 = byArray.length - n;
        }
        stringBuffer.append(new String(byArray, n, n2));
        return n + n2;
    }

    public static int serializeIP(String string, byte[] byArray, int n) {
        InetAddress inetAddress = null;
        byte[] byArray2 = null;
        try {
            inetAddress = InetAddress.getByName(string);
            byArray2 = inetAddress.getAddress();
        }
        catch (Exception exception) {
            byArray2 = new byte[]{0, 0, 0, 0};
        }
        byArray[n++] = byArray2[0];
        byArray[n++] = byArray2[1];
        byArray[n++] = byArray2[2];
        byArray[n++] = byArray2[3];
        return n;
    }

    public static int deserializeIP(byte[] byArray, int n, StringBuffer stringBuffer) {
        int n2 = byArray[n];
        int n3 = byArray[n + 1];
        int n4 = byArray[n + 2];
        int n5 = byArray[n + 3];
        if (n2 < 0) {
            n2 += 256;
        }
        if (n3 < 0) {
            n3 += 256;
        }
        if (n4 < 0) {
            n4 += 256;
        }
        if (n5 < 0) {
            n5 += 256;
        }
        stringBuffer.append(n2).append(".").append(n3).append(".").append(n4).append(".").append(n5);
        return n + 4;
    }

    public static int readToCRLF(InputStream inputStream, byte[] byArray, int n, int n2) throws Exception {
        boolean bl = false;
        while (n > 0) {
            int n3 = inputStream.read();
            if (n3 == -1) {
                throw new IOException("Connection closed by remote host.");
            }
            byArray[n2++] = (byte)n3;
            --n;
            if (bl) {
                if (n3 == 10) {
                    return n2 - 2;
                }
                bl = false;
            }
            if (n3 != 10 && n3 != 13) continue;
            bl = true;
        }
        throw new Exception("Out of buffer");
    }

    public static int readToLF(InputStream inputStream, byte[] byArray, int n, int n2) throws Exception {
        while (n > 0) {
            int n3 = inputStream.read();
            if (n3 == 0 || n3 == -1) {
                throw new IOException("Connection closed by remote host.");
            }
            byArray[n2++] = (byte)n3;
            --n;
            if (n3 != 10) continue;
            return n2 - 1;
        }
        throw new Exception("Out of buffer");
    }

    public static int readToCROrLF(InputStream inputStream, byte[] byArray, int n, int n2) throws Exception {
        while (n > 0) {
            int n3 = inputStream.read();
            if (n3 == 0 || n3 == -1) {
                throw new IOException("Connection closed by remote host.");
            }
            byArray[n2++] = (byte)n3;
            --n;
            if (n3 != 10 && n3 != 13) continue;
            return n2 - 1;
        }
        throw new Exception("Out of buffer");
    }
}

