/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import phex.DataChanger;
import phex.interfaces.IDataChangedListener;
import phex.utils.StrUtil;

public final class StatisticTracker {
    private DataChanger mStatusChangedListener = new DataChanger();
    private int mStatHosts;
    private int mStatFiles;
    private long mStatSize;
    private String mStatSizeStr;
    private int mStatTakenCount;
    private int mStatMsgCount;
    private int mStatDropCount;
    private int mStatUploadCount;
    private int mStatDownloadCount;
    private long mRateTime0;
    private int mRateBytes = 0;
    private int mOldRate = 0;
    private final long phexStartTimeMillis = System.currentTimeMillis();

    public StatisticTracker() {
        this.resetStat();
    }

    public long getPhexUptimeInSeconds() {
        return (System.currentTimeMillis() - this.phexStartTimeMillis) / 1000L;
    }

    public int getStatHosts() {
        return this.mStatHosts;
    }

    public void setStatHosts(int n) {
        this.mStatHosts = n;
    }

    public synchronized void incStatHosts(int n) {
        this.mStatHosts += n;
    }

    public int getStatFiles() {
        return this.mStatFiles;
    }

    public synchronized void incStatFiles(int n) {
        if (n < 0 || n > 1000000000 || this.mStatFiles == Integer.MAX_VALUE) {
            return;
        }
        this.mStatFiles = this.mStatFiles < Integer.MAX_VALUE - n ? (this.mStatFiles += n) : Integer.MAX_VALUE;
    }

    public long getStatSize() {
        return this.mStatSize;
    }

    public void setStatSize(long l) {
        this.mStatSize = l;
        this.updateStatSizeStr();
    }

    public synchronized void incStatSize(long l) {
        if (l < (long)0) {
            return;
        }
        this.mStatSize += l;
        this.updateStatSizeStr();
    }

    public String getStatSizeStr() {
        return this.mStatSizeStr;
    }

    private void updateStatSizeStr() {
        this.mStatSizeStr = StrUtil.formatSizeBytes(this.mStatSize << 10);
    }

    public int getStatTakenCount() {
        return this.mStatTakenCount;
    }

    public void setStatTakenCount(int n) {
        this.mStatTakenCount = n;
    }

    public synchronized void incStatTakenCount(int n) {
        this.mStatTakenCount += n;
    }

    public int getStatMsgCount() {
        return this.mStatMsgCount;
    }

    public void setStatMsgCount(int n) {
        this.mStatMsgCount = n;
    }

    public synchronized void incStatMsgCount(int n) {
        this.mStatMsgCount += n;
    }

    public int getStatDropCount() {
        return this.mStatDropCount;
    }

    public void setStatDropCount(int n) {
        this.mStatDropCount = n;
    }

    public synchronized void incStatDropCount(int n) {
        this.mStatDropCount += n;
    }

    public int getStatUploadCount() {
        return this.mStatUploadCount;
    }

    public void setStatUploadCount(int n) {
        this.mStatUploadCount = n;
    }

    public synchronized void incStatUploadCount(int n) {
        this.mStatUploadCount += n;
    }

    public int getStatDownloadCount() {
        return this.mStatDownloadCount;
    }

    public void setStatDownloadCount(int n) {
        this.mStatDownloadCount = n;
        this.mStatusChangedListener.dataChanged(null);
    }

    public synchronized void incStatDownloadCount(int n) {
        this.mStatDownloadCount += n;
        this.mStatusChangedListener.dataChanged(null);
    }

    public void resetStat() {
        this.mStatHosts = 0;
        this.mStatFiles = 0;
        this.mStatSize = 0L;
        this.updateStatSizeStr();
        this.mStatTakenCount = 0;
        this.mStatMsgCount = 0;
        this.mStatDropCount = 0;
        this.mStatUploadCount = 0;
        this.mStatDownloadCount = 0;
        this.newRateSamplePeriod();
    }

    public void incBytesCount(int n) {
        this.mRateBytes += n;
    }

    public final int getRate() {
        if (this.mRateBytes == 0) {
            return this.mOldRate;
        }
        return this.mRateBytes * 1000 / (int)(System.currentTimeMillis() - this.mRateTime0 + (long)1);
    }

    public void newRateSamplePeriod() {
        this.mOldRate = this.getRate();
        this.mRateBytes = 0;
        this.mRateTime0 = System.currentTimeMillis();
    }

    public void addStatusChangedListener(IDataChangedListener iDataChangedListener) {
        this.mStatusChangedListener.addListener(iDataChangedListener);
    }
}

