/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.Enumeration;
import java.util.Hashtable;
import phex.Res;
import phex.utils.HexDec;

public final class StrUtil {
    private static String sBlanks = "                                                                                                           ";
    public static final long s1kB = 1024L;
    public static final long s1MB = 0x100000L;
    public static final long s1GB = 0x40000000L;
    public static final long s1TB = 0x10000000000L;
    public static final long s1PB = 0x4000000000000L;
    public static DecimalFormat byteFormat = new DecimalFormat("0.00");

    public static String getAppNameVersion() {
        return String.valueOf(String.valueOf(new StringBuffer("PHEX ").append(Res.getStr("Program.Version")).append(" ").append(Res.getStr("Program.VersionComment"))));
    }

    public static String padStringLeft(String string, int n) {
        return String.valueOf(String.valueOf(StrUtil.getPadStr(string, n))).concat(String.valueOf(String.valueOf(string)));
    }

    public static String padStringRight(String string, int n) {
        return String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(StrUtil.getPadStr(string, n))));
    }

    public static String getPadStr(String string, int n) {
        int n2 = string.length();
        if (n2 >= n) {
            return " ";
        }
        return sBlanks.substring(0, n - n2);
    }

    public static String convertToLocalSystemFilename(String string) {
        string = StrUtil.replaceAllChar(string, '/', "_");
        return StrUtil.makeShortName(string, 255);
    }

    public static String makeShortName(String string, int n) {
        int n2 = string.length();
        if (n2 <= n) {
            return string;
        }
        int n3 = -1;
        if (n2 > 255) {
            n2 = 255;
        }
        for (int i = 0; i < n2; ++i) {
            n3 = (byte)(n3 ^ (byte)string.charAt(i));
        }
        byte[] byArray = new byte[]{(byte)n2};
        String string2 = HexDec.convertBytesToHexString(byArray);
        byArray[0] = n3;
        String string3 = HexDec.convertBytesToHexString(byArray);
        int n4 = string.lastIndexOf(".");
        if (n4 >= string.length() - 4) {
            String string4 = string.substring(n4);
            int n5 = string.length() - n4;
            string = string.substring(0, n - 4 - n5);
            return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(string2).append(string3).append(string4)));
        }
        string = string.substring(0, n - 4);
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(string2).append(string3)));
    }

    public static String getFileExt(String string) {
        int n = string.lastIndexOf(".");
        if (n > -1) {
            return string.substring(n + 1, string.length());
        }
        return "";
    }

    public static StringBuffer replaceAllChar(StringBuffer stringBuffer, char c, String string) {
        for (int i = stringBuffer.length() - 1; i >= 0; --i) {
            if (stringBuffer.charAt(i) != c) continue;
            stringBuffer.setCharAt(i, string.charAt(0));
            if (string.length() <= 1) continue;
            stringBuffer.insert(i + 1, string.substring(1));
        }
        return stringBuffer;
    }

    public static String replaceAllChar(String string, char c, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        StrUtil.replaceAllChar(stringBuffer, c, string2);
        return stringBuffer.toString();
    }

    public static String[] hashtableKeys2Strings(Hashtable hashtable) {
        String[] stringArray = new String[hashtable.size()];
        int n = 0;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public static String parseHost(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String parsePort(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String parseURLHostPort(String string) {
        try {
            int n = string.indexOf("//");
            if (n == -1) {
                String string2 = null;
                return string2;
            }
            n = string.indexOf("/", n + 2);
            String string3 = string.substring(0, n);
            return string3;
        }
        catch (Exception exception) {
            String string4 = null;
            return string4;
        }
    }

    public static String formatTime(int n) {
        int n2 = n / 3600;
        int n3 = (n - n2 * 3600) / 60;
        int n4 = n - n2 * 3600 - n3 * 60;
        StringBuffer stringBuffer = new StringBuffer(16);
        if (n2 > 9) {
            stringBuffer.append(n2);
        } else {
            stringBuffer.append("0");
            stringBuffer.append(n2);
        }
        stringBuffer.append(":");
        if (n3 > 9) {
            stringBuffer.append(n3);
        } else {
            stringBuffer.append("0");
            stringBuffer.append(n3);
        }
        stringBuffer.append(":");
        if (n4 > 9) {
            stringBuffer.append(n4);
        } else {
            stringBuffer.append("0");
            stringBuffer.append(n4);
        }
        return stringBuffer.toString();
    }

    public static String formatSignificantElapsedTime(long l) {
        long l2 = l % (long)60;
        long l3 = l / (long)60 % (long)60;
        long l4 = l / (long)3600 % (long)24;
        long l5 = l / (long)86400;
        StringBuffer stringBuffer = new StringBuffer(16);
        if (l5 > (long)0) {
            stringBuffer.append(l5).append("d ").append(l4).append("h");
        } else if (l4 > (long)0) {
            stringBuffer.append(l4).append("h ").append(l3).append("m");
        } else if (l3 > (long)0) {
            stringBuffer.append(l3).append("m ").append(l2).append("s");
        } else {
            stringBuffer.append(l2).append("s");
        }
        return stringBuffer.toString();
    }

    public static String formatSizeBytes(double d) {
        StringBuffer stringBuffer = new StringBuffer(16);
        if (d < (double)1024L) {
            byteFormat.format(d, stringBuffer, new FieldPosition(0)).append(" bytes");
        } else if (d < (double)0x100000L) {
            double d2 = d / (double)1024L;
            byteFormat.format(d2, stringBuffer, new FieldPosition(0)).append(" KB");
        } else if (d < (double)0x40000000L) {
            double d3 = d / (double)0x100000L;
            byteFormat.format(d3, stringBuffer, new FieldPosition(0)).append(" MB");
        } else if (d < (double)0x10000000000L) {
            double d4 = d / (double)0x40000000L;
            byteFormat.format(d4, stringBuffer, new FieldPosition(0)).append(" GB");
        } else if (d < (double)0x4000000000000L) {
            double d5 = d / (double)0x10000000000L;
            byteFormat.format(d5, stringBuffer, new FieldPosition(0)).append(" TB");
        } else {
            double d6 = d / (double)0x4000000000000L;
            byteFormat.format(d6, stringBuffer, new FieldPosition(0)).append(" PB");
        }
        return stringBuffer.toString();
    }

    public static String createNaturalSearchTerm(String string) {
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        string = string.replace('-', ' ');
        string = string.replace('.', ' ');
        string = string.replace('_', ' ');
        string = string.replace('(', ' ');
        string = string.replace(')', ' ');
        string = string.replace('[', ' ');
        string = string.replace(']', ' ');
        string.toLowerCase();
        string.trim();
        return string;
    }
}

