/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import phex.Debug;
import phex.utils.NotifyThrottleController;

final class ThrottleResetTimer
extends Thread {
    private final List throttles;
    private final long resetPeriodInMillis;
    private long lastSlideTime = 0L;

    public void registerThrottleController(NotifyThrottleController notifyThrottleController) {
        List list = this.throttles;
        synchronized (list) {
            this.throttles.add(notifyThrottleController);
        }
    }

    public synchronized boolean deregisterThrottleController(NotifyThrottleController notifyThrottleController) {
        List list = this.throttles;
        synchronized (list) {
            boolean bl = this.throttles.remove(notifyThrottleController);
            return bl;
        }
    }

    public ThrottleResetTimer(long l) {
        super("ThrottleResetTimer");
        this.resetPeriodInMillis = l;
        this.throttles = new LinkedList();
        this.start();
    }

    public long getRemainingTimeThisPeriod() {
        return this.resetPeriodInMillis - (System.currentTimeMillis() - this.lastSlideTime);
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(this.resetPeriodInMillis);
            }
            catch (Exception exception) {
                // empty catch block
            }
            List list = this.throttles;
            synchronized (list) {
                ListIterator listIterator = this.throttles.listIterator();
                while (listIterator.hasNext()) {
                    NotifyThrottleController notifyThrottleController = (NotifyThrottleController)listIterator.next();
                    notifyThrottleController.newRatePeriod();
                }
                this.lastSlideTime = System.currentTimeMillis();
            }
        }
    }

    private static void logInfo(String string) {
        Debug.msg(string);
    }
}

