/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import phex.utils.HexDec;

public class URLUtil {
    private static boolean[] sNeedEncode = new boolean[256];

    private URLUtil() {
    }

    public static String encodeURL(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (sNeedEncode[c]) {
                try {
                    outputStreamWriter.write(c);
                    outputStreamWriter.flush();
                }
                catch (IOException iOException) {
                    byteArrayOutputStream.reset();
                    continue;
                }
                byte[] byArray = byteArrayOutputStream.toByteArray();
                stringBuffer.append('%');
                HexDec.convertBytesToHexString(byArray, 0, byArray.length, stringBuffer);
                byteArrayOutputStream.reset();
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String decodeURL(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '%') {
                stringBuffer.append((char)Integer.parseInt(string.substring(i + 1, i + 3), 16));
                i += 2;
                continue;
            }
            if (c == '+') {
                stringBuffer.append(' ');
                continue;
            }
            stringBuffer.append(c);
        }
        return new String(stringBuffer.toString().getBytes("8859_1"));
    }

    public static void main(String[] stringArray) {
        try {
            String string = URLUtil.encodeURL(stringArray[0]);
            String string2 = URLUtil.decodeURL(string);
            System.out.println(string);
            System.out.println(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        for (int i = 0; i < 256; ++i) {
            URLUtil.sNeedEncode[i] = false;
        }
        URLUtil.sNeedEncode[43] = true;
        URLUtil.sNeedEncode[60] = true;
        URLUtil.sNeedEncode[62] = true;
        URLUtil.sNeedEncode[37] = true;
        URLUtil.sNeedEncode[61] = true;
        URLUtil.sNeedEncode[63] = true;
        URLUtil.sNeedEncode[59] = true;
        URLUtil.sNeedEncode[64] = true;
        URLUtil.sNeedEncode[38] = true;
        URLUtil.sNeedEncode[36] = true;
        URLUtil.sNeedEncode[44] = true;
        URLUtil.sNeedEncode[32] = true;
    }
}

