/*

 *  PHEX - The pure-java Gnutella-servent.

 *  Copyright (C) 2000 William W. Wong

 *  williamw@jps.net

 *

 *  This program is free software; you can redistribute it and/or modify

 *  it under the terms of the GNU General Public License as published by

 *  the Free Software Foundation; either version 2 of the License, or

 *  (at your option) any later version.

 *

 *  This program is distributed in the hope that it will be useful,

 *  but WITHOUT ANY WARRANTY; without even the implied warranty of

 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

 *  GNU General Public License for more details.

 *

 *  You should have received a copy of the GNU General Public License

 *  along with this program; if not, write to the Free Software

 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */



package phex;



import java.util.Iterator;

import java.util.LinkedList;

import phex.interfaces.IDataChangedListener;



/**

 * Listens for a data changed event and broadcasts the event to its listeners.

 */

public class DataChanger implements IDataChangedListener

{

	/** The list of listeners. */

	protected LinkedList mListeners = new LinkedList ();



	/**

	 * Adds the given listener to the list of listeners. The same listener

	 * cannot be added twice.

	 */

	public void addListener(IDataChangedListener listener)

	{

		synchronized (mListeners) {

			if (!mListeners.contains (listener)) {

				mListeners.add (listener);

			}

		}

	}



	/** Removes the given listener from the list of listeners. */

	public void removeListener(IDataChangedListener listener)

	{

		synchronized (mListeners) {

			mListeners.remove (listener);

		}

	}





	public void dataChanged(Object source)

	{

		synchronized (mListeners) {

			Iterator it = mListeners.iterator ();

			

			while (it.hasNext ()) {

				((IDataChangedListener) it.next ()).dataChanged (source);

			}

		}

	}

}





