
/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2000 William W. Wong
 *  williamw@jps.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package phex;


import java.io.*;
import java.net.*;
import java.util.*;

import phex.utils.*;


public class HttpRequest
{
    protected String mRequestLine;
    protected String mMethod;
    protected String mUri;
    protected String mVersion;
    protected Hashtable	mHeader = new Hashtable();


    protected HttpRequest()
    {
    }

    public String getMethod()
    {
        return mMethod;
    }

    public void setMethod(String method)
    {
        mMethod = method;
    }

    public String getUri()
    {
        return mUri;
    }

    public void setUri(String uri)
    {
        mUri = uri;
    }


    public String getVersion()
    {
        return mVersion;
    }


    public void setVersion(String version)
    {
        mVersion = version;
    }


    public void putHeader(String name, String value)
    {
        mHeader.put(name, value);
    }


    public String getHeader(String name)
    {
        return (String)mHeader.get(name);
    }

    public boolean readHeaders(InputStream is)
    {
        boolean succ = true;
        try
        {
            byte[] buf = new byte[1024];
            int	lenRead = IOUtil.readToCRLF(is, buf, 1024, 0);
            while ( lenRead > 0 )
            {
                StringBuffer strBuf = new StringBuffer();
                IOUtil.deserializeString(buf, 0, lenRead, strBuf);

                String headerLine = strBuf.toString().trim();
                int index = headerLine.indexOf(":");
                // Ignore malformed header line.
                if (index != -1)
                {
                    String name = headerLine.substring(0, index);
                    String value = headerLine.substring(index + 1);
                    putHeader( name.toUpperCase().trim(), value.trim() );
                }
                lenRead = IOUtil.readToCRLF( is, buf, 1024, 0 );
            }
        }
        catch (Exception e)
        {
            e.printStackTrace(  );
            succ = false;
        }
        return succ;
    }

    public String toString()
    {
        return mMethod + " " + mUri + " " + mVersion + "\r\n";
    }

}

