

/*

 *  PHEX - The pure-java Gnutella-servent.

 *  Copyright (C) 2000 William W. Wong

 *  williamw@jps.net

 *

 *  This program is free software; you can redistribute it and/or modify

 *  it under the terms of the GNU General Public License as published by

 *  the Free Software Foundation; either version 2 of the License, or

 *  (at your option) any later version.

 *

 *  This program is distributed in the hope that it will be useful,

 *  but WITHOUT ANY WARRANTY; without even the implied warranty of

 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

 *  GNU General Public License for more details.

 *

 *  You should have received a copy of the GNU General Public License

 *  along with this program; if not, write to the Free Software

 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */



package phex;





import java.lang.reflect.*;







public class Invoker implements Runnable

{

	private Object		mObject;

	private String		mMethodName;

	private Object[]	mParams = null;





	private Invoker()

	{

		// disable

	}





	public Invoker(Object obj, String methodName)

	{

		mObject = obj;

		mMethodName = methodName;

	}





	public Invoker(Object obj, String methodName, Object[] params)

	{

		mObject = obj;

		mMethodName = methodName;

		mParams = params;

	}





	public Invoker(Object obj, String methodName, Object param1)

	{

		mObject = obj;

		mMethodName = methodName;

		mParams = new Object[1];

		mParams[0] = param1;

	}





	public Invoker(Object obj, String methodName, Object param1, Object param2)

	{

		mObject = obj;

		mMethodName = methodName;

		mParams = new Object[2];

		mParams[0] = param1;

		mParams[1] = param2;

	}





	public void run()

	{

		try

		{

			Class[]	prototypeParams = null;



			if (mParams != null)

			{

				prototypeParams = new Class[mParams.length];

				for (int i = 0; i < mParams.length; i++)

				{

					prototypeParams[i] = mParams[i].getClass();

				}

			}



			Method	method = mObject.getClass().getDeclaredMethod(mMethodName, prototypeParams);

			method.invoke(mObject, mParams);

		}

		catch (Exception e)

		{

			System.out.println("Failed to invoke " + mMethodName + " of " + mObject);

			e.printStackTrace();

		}

	}



}







