
/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Mark Saltzman (marks@marksaltzman.com)
                       Gregor Koukkoullis ( gregor@kouk.de)
 *  Copyright (C) 2000 William W. Wong
 *  williamw@jps.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package phex;


import java.io.*;
import java.net.*;
import java.util.*;
import javax.swing.*;

import phex.connection.*;
import phex.host.*;
import phex.msg.*;
import phex.share.*;
import phex.utils.*;

public class PushWorker implements Runnable
{
    private MsgPushRequest	mPushMsg;

    private PushWorker()
    {
        // disable
    }

    public PushWorker(MsgPushRequest msg)
    {
        mPushMsg = msg;
        new Thread(this, "PushWorker-" + Integer.toHexString(hashCode())).start();
    }


    public void run()
    {

        ShareManager sm = ServiceManager.getShareManager();
        Host remoteHost = null;

        try
        {
            ShareFile sfile = sm.getFileAdministration().getFileByIndex(
                mPushMsg.getFileIndex() );
            if (sfile == null)
            {
                // File doesn't exist.
                return;
            }

            Socket sock = ServiceManager.getConnectionManager().connect(
                mPushMsg.getRequestHost(), mPushMsg.getRequestPort());
            HostAddress address = new HostAddress( mPushMsg.getRequestHost(),
                mPushMsg.getRequestPort() );
            remoteHost = new Host( address );
            remoteHost.setType(Host.sTypePush);
            remoteHost.setSock(sock);
            remoteHost.setOs(sock.getOutputStream());
            remoteHost.setIs(sock.getInputStream());

            // Send the push greeting.
            // GIV <file-ref-num>:<ClientID GUID in hexdec>/<filename>\n\n
            String pushGreeting = "GIV " +
                mPushMsg.getFileIndex() + ":" +
                mPushMsg.getClientID().toHexString() + "/" +
                sfile.getEffectiveName();
            byte[] buf = new byte[1024];
            int len = IOUtil.serializeString(pushGreeting, buf, 0);
            buf[len++] = (byte)'\n';
            buf[len++] = (byte)'\n';
            remoteHost.getOs().write(buf, 0, len);

            ConnectionRequest req = new ConnectionRequest( remoteHost );
            req.initialize();
            if (req.getMethod().equals(ConnectionRequest.sGet))
            {
                // Handle the HTTP GET as a normal HTTP GET to upload file.
                sm.httpRequestHandler(req, remoteHost);
            }
        }
        catch ( IOException exp )
        {
            //exp.printStackTrace();
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
    }
}