



/*

 *  PHEX - The pure-java Gnutella-servent.

 *  Copyright (C) 2000 William W. Wong

 *  williamw@jps.net

 *

 *  This program is free software; you can redistribute it and/or modify

 *  it under the terms of the GNU General Public License as published by

 *  the Free Software Foundation; either version 2 of the License, or

 *  (at your option) any later version.

 *

 *  This program is distributed in the hope that it will be useful,

 *  but WITHOUT ANY WARRANTY; without even the implied warranty of

 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

 *  GNU General Public License for more details.

 *

 *  You should have received a copy of the GNU General Public License

 *  along with this program; if not, write to the Free Software

 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */





package phex;





import java.util.*;

import java.net.*;

import java.io.*;

import java.awt.*;

import javax.swing.*;





public class Res

{

	private static Res				mRes = null;

	private static ResourceBundle	mResources = null;

	private static Hashtable		mDefaultIRC = null;





    static

	{

        try

		{

			mResources = ResourceBundle.getBundle("phex.resources.phex", 

                                                 Locale.getDefault());

			mRes = new Res();

        }

		catch (MissingResourceException mre)

		{

			System.err.println("phex/resources/phex.properties not found");

			System.exit(1);

        }

    }





	public static ResourceBundle getRes()

	{

		return mResources;

	}





	public static String getStr(String nm)

	{

		try

		{

			return mResources.getString(nm);

		}

		catch (MissingResourceException mre)

		{

			return null;

		}

	}





	public static URL getResourceURL(String key)

	{

		String	name = getStr(key);



		if (name == null)

			return null;

		

		return mRes.getClass().getResource("resources/" + name);

    }





	public static ImageIcon getIcon(String key)

	{

		URL	itemIconURL = Res.getResourceURL(key);

		if (itemIconURL != null)

		{

			return new ImageIcon(itemIconURL);

		}

		return null;

	}





	public static KeyStroke getAccelerator(String menuItemKey)

	{

		String			accel = getStr(menuItemKey);



		if (accel == null)

			return null;



		try

		{

			StringTokenizer	enum = new StringTokenizer(accel, "-");

			String			modifier = (String)enum.nextToken();

			String			key = (String)enum.nextToken();



			modifier = modifier.trim().toLowerCase();

			key = key.trim();

			if (modifier.equals("ctrl"))

			{

				return KeyStroke.getKeyStroke(key.charAt(0), Event.CTRL_MASK);

			}

			else if (modifier.equals("alt"))

			{

				return KeyStroke.getKeyStroke(key.charAt(0), Event.ALT_MASK);

			}

			else if (modifier.equals("function"))

			{

				// F1, F2, F3, etc

				int			num = Integer.parseInt(key.substring(1)) - 1;

				return KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F1 + num, 0);

			}

			else if (modifier.equals("none"))

			{

				return KeyStroke.getKeyStroke(key);

			}

		}

		catch (Exception e)

		{

			System.out.println("Error parsing accelerator key, '" + menuItemKey + ".'  "+ e);

		}



		return null;

	}





	public static Vector getLines(String filename)

	{

		Class				classObj = mRes.getClass();

		Vector				result = new Vector();



		try

		{

			InputStream			is = classObj.getResourceAsStream(filename);

			BufferedReader		br = new BufferedReader(new InputStreamReader(is));

			LineNumberReader	reader = new LineNumberReader(br);

			String				line;



			while ((line = reader.readLine()) != null)

			{

				if (line.startsWith("#") || line.startsWith(";"))

					continue;

				result.addElement(line);

			}

		}

		catch (Exception e)

		{

			e.printStackTrace();

			System.out.println(e);

		}



		return result;

	}





	public static Properties loadProperties(String filename)

	{

		Class				classObj = mRes.getClass();

		Properties			results = new Properties();



		try

		{

			InputStream			is = classObj.getResourceAsStream(filename);

			results.load(is);

			is.close();

		}

		catch (Exception e)

		{

			e.printStackTrace();

			System.out.println(e);

		}



		return results;

	}







}





