

/*

 *  PHEX - The pure-java Gnutella-servent.

 *  Copyright (C) 2000 William W. Wong

 *  williamw@jps.net

 *

 *  This program is free software; you can redistribute it and/or modify

 *  it under the terms of the GNU General Public License as published by

 *  the Free Software Foundation; either version 2 of the License, or

 *  (at your option) any later version.

 *

 *  This program is distributed in the hope that it will be useful,

 *  but WITHOUT ANY WARRANTY; without even the implied warranty of

 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

 *  GNU General Public License for more details.

 *

 *  You should have received a copy of the GNU General Public License

 *  along with this program; if not, write to the Free Software

 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */





package phex;



import phex.cqueue.*;

import phex.host.*;

import phex.interfaces.*;





public class SendManager

{

	private CQueue		mSendQueue;

	private CQueue		mFreeQueue;





	SendManager()

	{

		// Create queues with max-size, dropping the oldest msg when max reached.

		mSendQueue = new CQueue(5000, true);

		mFreeQueue = new CQueue(5000, true);



		// resolve: save the SendWorkers and manage them.

		SendWorker		worker;

		worker = new SendWorker(this);				

		worker.startup();

		worker = new SendWorker(this);

		worker.startup();

		worker = new SendWorker(this);

		worker.startup();

		worker = new SendWorker(this);

		worker.startup();

	}





	public synchronized void queueMsgToSend(Host destinationHost, IMsg msg, boolean urgent)

	{

		HostMsg		entry = (HostMsg)mFreeQueue.removeFromHead();

		

		if (entry == null)

		{

			entry = new HostMsg();

		}



		entry.setHost(destinationHost);

		entry.setMsg(msg);

		entry.setUrgent(urgent);



		queueMsgToSend(entry);

	}





	public synchronized void queueMsgToSend(HostMsg entry)

	{

		try

		{

			if (entry.getUrgent())

			{

				mSendQueue.addToHead(entry);

			}

			else

			{

				mSendQueue.addToTail(entry);

			}

		}

		catch (Exception e)

		{

			e.printStackTrace();

		}



		notifyAll();

	}





	public synchronized HostMsg getNextHostMsg()

	{

		HostMsg		entry;



		while ((entry = (HostMsg)mSendQueue.removeFromHead()) == null)

		{

			try

			{

				wait();

			}

			catch (Exception e)

			{

				// ignore

			}

		}

		return entry;

	}





	public synchronized void freeHostMsg(HostMsg entry)

	{

		try

		{

			entry.setHost(null);

			entry.setMsg(null);

			mFreeQueue.addToTail(entry);

		}

		catch (Exception e)

		{

			e.printStackTrace();

		}

	}





	private void queueDummyMsg()

	{

		queueMsgToSend(null, null, false);

	}



}





