/*

 *  PHEX - The pure-java Gnutella-servent.

 *  Copyright (C) 2000 William W. Wong

 *  williamw@jps.net

 *

 *  This program is free software; you can redistribute it and/or modify

 *  it under the terms of the GNU General Public License as published by

 *  the Free Software Foundation; either version 2 of the License, or

 *  (at your option) any later version.

 *

 *  This program is distributed in the hope that it will be useful,

 *  but WITHOUT ANY WARRANTY; without even the implied warranty of

 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

 *  GNU General Public License for more details.

 *

 *  You should have received a copy of the GNU General Public License

 *  along with this program; if not, write to the Free Software

 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */





package phex;





import javax.swing.*;

import java.awt.*;

import java.awt.event.*;





public class SplashWindow extends JWindow

{

	private Image	mBkgd;





	public SplashWindow()

	{

		ImageIcon	icon = Res.getIcon("Splash.Image");

		mBkgd = icon.getImage();

		setSize(mBkgd.getWidth(null) - 2, mBkgd.getHeight(null));

		BaseFrame.centerWindow(this, new Point(0, 0));

		setVisible(true);

	}





	public void update(Graphics g)

	{

		// Paint directly to avoid clearing the screen.

		paint(g);

	}





	public void paint(Graphics g)

	{

		super.paint(g);



		Dimension	size = getSize();

		g.drawImage(mBkgd, -1, 0, null);

		g.setColor(Color.darkGray);

		g.drawRect(0, 0, size.width-1, size.height-1);

		g.setColor(Color.yellow);

	}



}



