
/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Konrad Haenel (www.konrad-haenel.de)
 *  Copyright (C) 2000 William W. Wong
 *  williamw@jps.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package phex.actions.view;


import java.awt.event.*;
import java.util.*;
import java.net.*;
import javax.swing.*;

import phex.*;
import phex.actions.base.*;
import phex.utils.*;


/**
*	The ActionViewAbout class performs the operation of displaying the About
*	dialog box describing this program.
*/
public class ActionViewAbout extends ActionBase
{
    public ActionViewAbout(BaseFrame frame, String label, Icon icon)
    {
        super(frame, label, icon);
    }


    public void actionPerformed(ActionEvent event)
    {
        Object[] objArr =
            {
                StrUtil.getAppNameVersion(),
                Res.getStr("Program.EMail"),
                Res.getStr("Program.Url")
            };
        JOptionPane.showMessageDialog(
            mFrame,
            Localizer.getFormatedString( "AboutText", objArr ),
            Localizer.getString( "About" ),
            JOptionPane.INFORMATION_MESSAGE);
    }


    public void refresh()
    {
        // Can always bring up the About dialog.
        setEnabled(true);
    }
}


