/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Gregor Koukkoullis ( phex@kouk.de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex.common;

import java.util.*;
import phex.common.TransferDataProvider;

public class TransferRateService
{
    private HashSet providerSet;

    public TransferRateService()
    {
        providerSet = new HashSet();
    }

    public synchronized void registerTransferDataProvider( TransferDataProvider provider )
    {
        providerSet.add( provider );
    }

    public synchronized void unregisterTransferDataProvider( TransferDataProvider provider )
    {
        providerSet.remove( provider );
    }

    public synchronized void setTransferRateTimestamp( )
    {
        long currentTime = System.currentTimeMillis();
        Iterator iterator = providerSet.iterator();
        while ( iterator.hasNext() )
        {
            TransferDataProvider provider =
                ( TransferDataProvider ) iterator.next();
            provider.setTransferRateTimestamp( currentTime );
        }
    }
}