/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Gregor Koukkoullis ( phex@kouk.de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex.connection;

import java.net.*;
import java.io.*;

import phex.Res;
import phex.utils.*;

public class HTTPURLRequest
{
    public static String loadPage( URL url )
    {
        try
        {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setUseCaches( false );
            connection.setRequestProperty( "User-Agent", StrUtil.getAppNameVersion() );

            BufferedInputStream inStream =
                new BufferedInputStream(connection.getInputStream());

            int i;
            StringBuffer buffer = new StringBuffer();
            while( (i = inStream.read()) != -1 )
            {
                buffer.append((char)i);
            }
            return buffer.toString();
        }
        catch ( UnknownHostException exp )
        {
            // can't find way to host
            // this maybe means we have no internet connection
            return null;
        }
        catch ( ConnectException exp )
        {
            // can't connect... maybe a proxy is in the way...
            return null;
        }
        catch ( IOException exp )
        {
            exp.printStackTrace();
            return null;
        }
    }
}