

/*

 *  PHEX - The pure-java Gnutella-servent.

 *  Copyright (C) 2000 William W. Wong

 *  williamw@jps.net

 *

 *  This program is free software; you can redistribute it and/or modify

 *  it under the terms of the GNU General Public License as published by

 *  the Free Software Foundation; either version 2 of the License, or

 *  (at your option) any later version.

 *

 *  This program is distributed in the hope that it will be useful,

 *  but WITHOUT ANY WARRANTY; without even the implied warranty of

 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

 *  GNU General Public License for more details.

 *

 *  You should have received a copy of the GNU General Public License

 *  along with this program; if not, write to the Free Software

 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */





package phex.cqueue;



import phex.*;





public class CQueue implements CQueueEntry

{

	private CQueueEntry		mHeadTail;

	private int				mCount;

	private int				mMax;

	private boolean			mEnforcingMax;





	private CQueue()

	{

	}





	public CQueue(int max, boolean EnforcingMax)

	{

		mMax = max;

		mEnforcingMax = EnforcingMax;

		initQueue();

	}





	private void initQueue()

	{

		CQueueEntry	entry = new CQueue();

		entry.setNext(entry);

		entry.setPrev(entry);

		entry.setCQueue(this);



		mHeadTail = entry;

		mCount = 0;

	}





	public int getCount()

	{

		return mCount;

	}





	public int getMax()

	{

		return mMax;

	}





	public boolean isExceedingMax()

	{

		return (mCount > mMax);

	}





	public boolean isEmpty()

	{

		return (mHeadTail.getNext() == mHeadTail);

	}





	public void addToTail(CQueueEntry entry)

			throws CQueueException

	{

		if (mEnforcingMax && mCount > mMax)

		{

			removeFromHead();

		}

		addBefore(mHeadTail, entry);

	}





	public void addToHead(CQueueEntry entry)

			throws CQueueException

	{

		if (mEnforcingMax && mCount > mMax)

		{

			removeFromTail();

		}

		addAfter(mHeadTail, entry);

	}		





	private void addAfter(CQueueEntry a, CQueueEntry entry)

			throws CQueueException

	{

		if (a.getCQueue() != this)

		{

			throw new CQueueException("The entry to be followed doesn't belong to the same queue.");

		}

		if (entry.getCQueue() != null)

		{

			throw new CQueueException("The entry to be added already belongs to another queue.");

		}

		entry.setPrev(a);

		entry.setNext(a.getNext());

		a.getNext().setPrev(entry);

		a.setNext(entry);

		entry.setCQueue(this);

		mCount++;

	}





	private void addBefore(CQueueEntry a, CQueueEntry entry)

			throws CQueueException

	{

		if (a.getCQueue() != this)

		{

			throw new CQueueException("The entry to follow doesn't belong to the same queue.");

		}

		if (entry.getCQueue() != null)

		{

			throw new CQueueException("The entry to be added already belongs to another queue.");

		}

		entry.setNext(a);

		entry.setPrev(a.getPrev());

		a.getPrev().setNext(entry);

		a.setPrev(entry);

		entry.setCQueue(this);

		mCount++;

	}





	public CQueueEntry remove(CQueueEntry entry)

	{

		CQueueEntry	prev = entry.getPrev();

		CQueueEntry	next = entry.getNext();



		if (prev == null || next == null)

		{

			return entry;

		}

		prev.setNext(next);

		next.setPrev(prev);



		entry.setNext(null);

		entry.setPrev(null);

		entry.getCQueue().mCount--;

		entry.setCQueue(null);



		return entry;

	}





	public CQueueEntry removeFromHead()

	{

		if (isEmpty())

			return null;



		return remove(mHeadTail.getNext());

	}





	public CQueueEntry removeFromTail()

	{

		if (isEmpty())

			return null;



		return remove(mHeadTail.getPrev());

	}









	private	CQueueEntry	mNext = null;

	private CQueueEntry	mPrev = null;

	private CQueue		mQueue = null;



	public CQueueEntry getPrev()

	{

		return mPrev;

	}



	public void setPrev(CQueueEntry prev)

	{

		mPrev = prev;

	}



	public CQueueEntry getNext()

	{

		return mNext;

	}



	public void setNext(CQueueEntry next)

	{

		mNext = next;

	}



	public void setCQueue(CQueue queue)

	{

		mQueue = queue;

	}



	public CQueue getCQueue()

	{

		return mQueue;

	}





}



