
/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2000 William W. Wong
 *  williamw@jps.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package phex.dialogues;


import java.awt.*;
import java.awt.event.*;
import java.util.*;

import javax.swing.event.*;
import javax.swing.*;

import phex.*;
import phex.config.*;
import phex.gui.common.GUIUtils;


public class DlgConfigProxy extends JDialog implements KeyListener
{
    private BaseFrame			mFrame;
    private boolean				mCancel;
    private JTextField			mProxyHostText;
    private JTextField			mProxyPortText;
    private JCheckBox			mAuthentication;
    private JLabel				mUsernameLabel;
    private JTextField			mProxyUsernameText;
    private JLabel				mPasswordLabel;
    private JPasswordField		mProxyPassword;



    DlgConfigProxy(BaseFrame frame)
    {
        super(frame, true);
        mFrame = frame;

        setTitle("Enter Socks5 Proxy Server Information");
        setDefaultCloseOperation(JDialog.HIDE_ON_CLOSE);


        // Center panel for holding the fields
        JPanel		centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(
            BorderFactory.createCompoundBorder(
                BorderFactory.createCompoundBorder(
                    BorderFactory.createEmptyBorder(20, 20, 6, 20),
                    BorderFactory.createEtchedBorder()),
                BorderFactory.createEmptyBorder(16, 20, 20, 20)));

        mAuthentication = new JCheckBox("Authentication", (ServiceManager.sCfg.mProxyUserName.length() > 0));
        mAuthentication.addActionListener(new AuthenticationHandler());

        // Data panel
        JPanel		labelPanel = new JPanel(new GridLayout(5, 1, 10, 0));
        mUsernameLabel = new JLabel("Proxy User Name: ");
        mPasswordLabel = new JLabel("Proxy Password: ");
        labelPanel.add(new JLabel("Proxy Hostname/IP: "));
        labelPanel.add(new JLabel("Proxy Port: "));
        labelPanel.add(mAuthentication);
        labelPanel.add(mUsernameLabel);
        labelPanel.add(mPasswordLabel);

        JPanel		inputPanel = new JPanel(new GridLayout(5, 1, 0, 6));
        mProxyHostText = new JTextField(ServiceManager.sCfg.mProxyHost, 15);
        mProxyPortText = new JTextField("" + ServiceManager.sCfg.mProxyPort, 15);
        GUIUtils.setToolTipText(mProxyPortText, "My listening port for other to connect to me.  Set to 0 for random port.");
        mProxyUsernameText = new JTextField(ServiceManager.sCfg.mProxyUserName, 15);
        mProxyPassword = new JPasswordField(ServiceManager.sCfg.mProxyPassword, 15);
        inputPanel.add(mProxyHostText);
        inputPanel.add(mProxyPortText);
        inputPanel.add(new JLabel(" "));
        inputPanel.add(mProxyUsernameText);
        inputPanel.add(mProxyPassword);

        centerPanel.add(BorderLayout.WEST, labelPanel);
        centerPanel.add(BorderLayout.CENTER, inputPanel);

        getContentPane().add(BorderLayout.CENTER, centerPanel);

        // Buttons panel
        JPanel			buttonPanel = new JPanel(new FlowLayout());
        JButton			ok = new JButton("OK");
        JButton			cancel = new JButton("Cancel");
        ActionListener	actionListener = new ActionListener()
        {
            public void actionPerformed(ActionEvent event)
            {
                if (!event.getActionCommand().equals("Cancel"))
                {
                    if (!doOk())
                        return;
                }
                else
                {
                    mCancel = true;
                }
                setVisible(false);
            }
        };

        ok.addActionListener(actionListener);
        ok.setMnemonic('O');
        cancel.addActionListener(actionListener);
        cancel.setMnemonic('C');
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        getContentPane().add(BorderLayout.SOUTH, buttonPanel);

        enableUserPassword();

        addKeyListener(this);

        pack();

        BaseFrame.centerWindow(this, new Point(0, 0));
    }


    private void enableUserPassword()
    {
        mUsernameLabel.setEnabled(mAuthentication.isSelected());
        mProxyUsernameText.setEnabled(mAuthentication.isSelected());
        mPasswordLabel.setEnabled(mAuthentication.isSelected());
        mProxyPassword.setEnabled(mAuthentication.isSelected());
    }


    boolean getCancel()
    {
        return mCancel;
    }


    private boolean doOk()
    {
        String	host = mProxyHostText.getText().trim();
        String	portStr = mProxyPortText.getText().trim();
        String	user = mProxyUsernameText.getText().trim();
        String	password = mProxyPassword.getText().trim();
        int		port;

        if (!mAuthentication.isSelected())
        {
            user = "";
            password = "";
        }

        if (host.length() == 0)
        {
            JOptionPane.showMessageDialog(mFrame,
                                          "Please enter the hostname or IP address for the proxy server.", "Invalid Input",
                                          JOptionPane.ERROR_MESSAGE);
            mProxyHostText.requestFocus();
            return false;
        }

        try
        {
            port = Integer.parseInt(portStr);
            if (port < 0)
                throw new Exception();
        }
        catch (Exception e)
        {
            JOptionPane.showMessageDialog(mFrame,
                                          "Please enter a non-negative integer for the port.", "Invalid Input",
                                          JOptionPane.ERROR_MESSAGE);
            mProxyPortText.requestFocus();
            return false;
        }

        ServiceManager.sCfg.mProxyHost = host;
        ServiceManager.sCfg.mProxyPort = port;
        ServiceManager.sCfg.mProxyUserName = user;
        ServiceManager.sCfg.mProxyPassword = password;
        ServiceManager.sCfg.save();

        mCancel = false;
        return true;
    }


    // KeyListener implementation
    public void keyPressed(KeyEvent e)
    {
    }


    public void keyReleased(KeyEvent e)
    {
        if (e.getKeyCode() == KeyEvent.VK_ESCAPE)
        {
            mCancel = true;
            setVisible(false);
        }
        else if (e.getKeyCode() == KeyEvent.VK_ENTER)
        {
            if (!doOk())
                return;
            mCancel = false;
            setVisible(false);
        }
    }


    public void keyTyped(KeyEvent e)
    {
    }


    private class AuthenticationHandler implements ActionListener
    {
        public void actionPerformed(ActionEvent e)
        {
            enableUserPassword();
        }
    }

}

