
/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2000 William W. Wong
 *  williamw@jps.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package phex.dialogues;


import java.awt.*;
import java.awt.event.*;
import java.util.*;

import javax.swing.event.*;
import javax.swing.*;

import phex.*;
import phex.config.*;


public class DlgNetwork extends JDialog implements KeyListener
{
    private BaseFrame			mFrame;
    private boolean				mCancel;
    private JComboBox			mNetworkCombo;
    private JCheckBox			mAutoJoinCheck;
//	private JTextField			mPasswordText;




    public DlgNetwork(BaseFrame frame)
    {
        super(frame, true);
        mFrame = frame;

        setTitle("Join Network");
        setDefaultCloseOperation(JDialog.HIDE_ON_CLOSE);

        JPanel		descPanel = new JPanel(new BorderLayout());
        descPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 0, 0));
        descPanel.add(BorderLayout.CENTER, new JLabel("Enter the network name to join."));

        // Center panel for holding the fields
        JPanel		centerPanel = new JPanel(new BorderLayout());

        JPanel		networkPanel = new JPanel(new BorderLayout());
        networkPanel.setBorder(
            BorderFactory.createCompoundBorder(
                BorderFactory.createCompoundBorder(
                    BorderFactory.createEmptyBorder(20, 20, 8, 20),
                    BorderFactory.createEtchedBorder()),
                BorderFactory.createEmptyBorder(16, 20, 20, 20)));
        mNetworkCombo = new JComboBox();
        mNetworkCombo.setEditable(true);
        mNetworkCombo.addActionListener(new ComboActionHandler());
        mAutoJoinCheck = new JCheckBox("Join the network automatically at start up.", ServiceManager.sCfg.mAutoJoin);
        networkPanel.add(BorderLayout.NORTH, new JLabel("Network Name:"));
        networkPanel.add(BorderLayout.CENTER, mNetworkCombo);
        networkPanel.add(BorderLayout.SOUTH, mAutoJoinCheck);

/*		String		password = (String)ServiceManager.sCfg.mNetworkPasswords.get(ServiceManager.sCfg.mCurrentNetwork);
        if (password == null)
            password = "";

        JPanel		passwordPanel = new JPanel(new BorderLayout());
        mPasswordText = new JTextField(password);
        passwordPanel.add(BorderLayout.NORTH, new JLabel("Password:"));
        passwordPanel.add(BorderLayout.CENTER, mPasswordText);
        passwordPanel.setBorder(
            BorderFactory.createCompoundBorder(
                BorderFactory.createCompoundBorder(
                    BorderFactory.createEmptyBorder(0, 20, 20, 20),
                    BorderFactory.createEtchedBorder()),
                BorderFactory.createEmptyBorder(16, 20, 20, 20)));
*/
        centerPanel.add(BorderLayout.CENTER, networkPanel);
//		centerPanel.add(BorderLayout.SOUTH, passwordPanel);

        getContentPane().add(BorderLayout.NORTH, descPanel);
        getContentPane().add(BorderLayout.CENTER, centerPanel);

        // Buttons panel
        JPanel			buttonPanel = new JPanel(new FlowLayout());
        JButton			ok = new JButton("Join");
        JButton			cancel = new JButton("Cancel");
        ActionListener	actionListener = new ActionListener()
        {
            public void actionPerformed(ActionEvent event)
            {
                if (!event.getActionCommand().equals("Cancel"))
                {
                    if (!doOk())
                        return;
                }
                else
                {
                    mCancel = true;
                }
                setVisible(false);
            }
        };

        ok.addActionListener(actionListener);
        ok.setMnemonic('J');
        cancel.addActionListener(actionListener);
        cancel.setMnemonic('C');
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        getContentPane().add(BorderLayout.SOUTH, buttonPanel);

        addKeyListener(this);

        mNetworkCombo.addItem(ServiceManager.sCfg.sGeneralNetwork);
        for (int i = 0; i < ServiceManager.sCfg.mNetNetworkHistory.size(); i++)
        {
            mNetworkCombo.addItem(ServiceManager.sCfg.mNetNetworkHistory.elementAt(i));
        }
        mNetworkCombo.setSelectedItem(ServiceManager.sCfg.mCurrentNetwork);

        pack();

        BaseFrame.centerWindow(this, new Point(0, 0));
    }


    public boolean getCancel()
    {
        return mCancel;
    }


    private boolean doOk()
    {
        String	network = ((String)mNetworkCombo.getEditor().getItem()).trim();
        if (network.length() == 0)
            network = ServiceManager.sCfg.sGeneralNetwork;
        ServiceManager.sCfg.mCurrentNetwork = network;
        ServiceManager.sCfg.mAutoJoin = mAutoJoinCheck.isSelected();

        int		i;
        for (i = 0; i < ServiceManager.sCfg.mNetNetworkHistory.size(); i++)
        {
            if (network.equals(ServiceManager.sCfg.mNetNetworkHistory.elementAt(i)))
                break;
        }
        if (!network.equals(ServiceManager.sCfg.sGeneralNetwork) &&
            i == ServiceManager.sCfg.mNetNetworkHistory.size())
        {
            ServiceManager.sCfg.mNetNetworkHistory.insertElementAt(network, 0);
        }
        if (ServiceManager.sCfg.mNetNetworkHistory.size() > 20)
        {
            ServiceManager.sCfg.mNetNetworkHistory.removeElementAt(20);
        }

        //String	password = mPasswordText.getText().trim();
        //ServiceManager.sCfg.mNetworkPasswords.put(ServiceManager.sCfg.mCurrentNetwork, password);

        ServiceManager.sCfg.save();

        mCancel = false;
        return true;
    }


    // KeyListener implementation
    public void keyPressed(KeyEvent e)
    {
    }


    public void keyReleased(KeyEvent e)
    {
        if (e.getKeyCode() == KeyEvent.VK_ESCAPE)
        {
            mCancel = true;
            setVisible(false);
        }
        else if (e.getKeyCode() == KeyEvent.VK_ENTER)
        {
            if (!doOk())
                return;
            mCancel = false;
            setVisible(false);
        }
    }


    public void keyTyped(KeyEvent e)
    {
    }



    private class ComboActionHandler implements ActionListener
    {
        public void actionPerformed(ActionEvent e)
        {
            String	network = ((String)mNetworkCombo.getEditor().getItem()).trim();
            //String	password = (String)ServiceManager.sCfg.mNetworkPasswords.get(network);
            //if (password == null)
            //    password = "";

            //mPasswordText.setText(password);
        }
    }


}

