/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2000 William W. Wong
 *  williamw@jps.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package phex;

import java.io.*;
import java.util.*;
import java.net.*;
import java.applet.*;

import phex.utils.*;

/**
 * This class is used for the normal startup of phex.
 */
public class f
{
        /**
         * Main for phex.
         */
        public static void main(String[] args)
        {
                try
                {
                        parseArgs(args);
                        // help was needed
                        if (helpMsg)
                        {
                                printHelp();
                                System.exit(0);
                        }
                        if (Debug.DbgVerbose(2))
                                Debug.verbose.println( "Verbose level: "+verbose);
                        // Initialize ServiceManager.
                        ServiceManager.getManager();
                        MainFrame mainframe = new MainFrame(null, new SplashWindow());
                }
                catch (Exception e)
                {
                        e.printStackTrace();
                }
        }

        /**
         * Command line arguments are global. They aren't public since
         * they are analysed here.
         */
        private static boolean helpMsg= false;
        private static int     verbose= 1;


        /**
         * Parses the command line. Examples for valid lines follow:<br>
         * -h displays help message<br>
         * -vvv very high verbose level<br>
         * -q don't verbose<br>
         * -d d2ga debug string<br>
         * -dvd d2 gad0g0a0 -vqv funny command line. Doesn't do anything!
         */
        private static void parseArgs(String[] args)
        {
                int extra = 0;
                int pos = 0;
                char c;
                int token= 0;
                while(token<args.length)
                {
                        if (Debug.DbgVerbose(4)) Debug.verbose.println("parseArgs token: "+token+" is: "+args[token]+" pos: "+pos+" help: "+helpMsg);
                        if (args[token].startsWith("--"))
                        {
                                if (args[token].equals("--help")) {
                                        helpMsg= true;
                                 }
                                token+=extra+1;
                                extra=0;
                        }
                        else if (args[token].startsWith("-"))
                        {
                                c= args[token].charAt(pos);
                                switch(c) {
                                case 'h' :
                                        helpMsg= true;
                                        break;
                                case 'v' :
                                        verbose++;
                                        if ( verbose>9 ) verbose =9;
                                        Debug.setDebug("v"+verbose);
                                        break;
                                case 'q' :
                                        verbose= 0;
                                        Debug.setDebug("v"+verbose);
                                        break;
                                case 'd' :
                                        extra++;
                                        int opt= token+extra;
                                        if (opt < args.length)
                                                Debug.setDebug(args[opt]);
                                        else
                                                helpMsg= true;
                                        break;
                                default :
                                        if (pos>0) helpMsg= true;
                                        break;
                                }
                                pos++;
                                if (pos >= args[token].length()) {
                                        pos= 0;
                                        token+=extra+1;
                                        extra=0;
                                }
                        }
                        else
                        {
                                /* TODO reintegrate
                                if (token+1 == args.length)
                                        ServiceManager.setConfigFilename(args[token]);
                                else
                                */
                                helpMsg = true;
                                token += extra+1;
                                extra = 0;
                        }
                }
        }

        /**
         * Prints the usage for Phex
         */
        private static void printHelp()
        {
                Debug.verbose.println(
                "PHEX - the pure java gnutella servent\n"+
                "version: "+ StrUtil.getAppNameVersion()+"\n"+
                "usage: java -jar phex.jar [-h] [-v] [-q] [config file]\n"+
                "  -h          This help message\n"+
                "  -d debugStr define debug level\n"+
                "  -v          Be more verbose\n"+
                "  -q          Be absolutely quiet\n");
                Debug.verbose.flush();
        }
}
