/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Gregor Koukkoullis ( phex@kouk.de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex.gui.dialogs.options;

import java.awt.*;
import javax.swing.*;
import java.util.HashMap;
import phex.ServiceManager;
import phex.gui.common.IntegerTextField;
import phex.utils.Localizer;

public class DownloadPane extends OptionsSettingsPane
{
    private static final String SIMULTANEOUS_DOWNLOADS_KEY = "SimultaneousDownloads";
    private static final String DOWNLOADS_PER_HOST_KEY = "DownloadsPerHost";

    private IntegerTextField simultaneousDonwnloadsTF;
    private IntegerTextField donwnloadsPerHostTF;
    private JCheckBox removeCompletedDownloadsChkbx;

    public DownloadPane()
    {
        super( "Download" );
    }

    /**
     * Called when preparing this settings pane for display the first time. Can
     * be overriden to implement the look of the settings pane.
     */
    protected void prepareComponent()
    {
        GridBagConstraints constraints;
        setLayout( new GridBagLayout() );

        JPanel generalPanel = new JPanel( new GridBagLayout() );
        generalPanel.setBorder( BorderFactory.createTitledBorder(
            BorderFactory.createEtchedBorder(),
            Localizer.getString( "GeneralDownloadSettings" ) ) );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.BOTH;
            constraints.weightx = 1;
            constraints.weighty = 1;
        add( generalPanel, constraints );

        JPanel panel = new JPanel( new GridBagLayout() );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 3, 0, 5, 0 );
            constraints.weightx = 1;
        generalPanel.add( panel, constraints );

        JLabel label = new JLabel( Localizer.getString( "SimultaneousDownloads" ) + ": " );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 0, 0, 5 );
        panel.add( label, constraints );

        simultaneousDonwnloadsTF = new IntegerTextField(
            String.valueOf( ServiceManager.sCfg.mMaxDownload ), 3, 3 );
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
        panel.add( simultaneousDonwnloadsTF, constraints );

        panel = new JPanel( new GridBagLayout() );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 0, 5, 0 );
            constraints.weightx = 1;
        generalPanel.add( panel, constraints );

        label = new JLabel( Localizer.getString( "DownloadsPerHost" ) + ": ");
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 0, 0, 5 );
        panel.add( label, constraints );

        donwnloadsPerHostTF = new IntegerTextField(
            String.valueOf( ServiceManager.sCfg.mMaxDownloadPerIP ), 3, 3 );
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
        panel.add( donwnloadsPerHostTF, constraints );

        removeCompletedDownloadsChkbx = new JCheckBox(
            Localizer.getString( "AutoRemoveCompletedDownloads" ),
            ServiceManager.sCfg.mDownloadAutoRemoveCompleted );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 0, 5, 0 );
            constraints.weightx = 1;
            constraints.weighty = 1;
        generalPanel.add( removeCompletedDownloadsChkbx, constraints );
    }

    /**
     * Override this method if you like to verify inputs before storing them.
     * A input dictionary is given to the pane. It can be used to store values
     * like error flags or prepared values for saving. The dictionary is given
     * to every settings pane checkInput(), displayErrorMessage() and
     * saveAndApplyChanges() method.
     * When the input has been flaged as invalid with the method setInputValid()
     * the method displayErrorMessage() is called directly after return of
     * checkInput() and the focus is given to settings pane.
     * After checking all settings pane without any error the method
     * saveAndApplyChanges() is called for all settings panes to save the
     * changes.
     */
    public void checkInput( HashMap inputDic )
    {
        try
        {
            String simultaneousDownloadsStr = simultaneousDonwnloadsTF.getText();
            Integer simultaneousDownloads = new Integer( simultaneousDownloadsStr );
            inputDic.put( SIMULTANEOUS_DOWNLOADS_KEY, simultaneousDownloads );
        }
        catch ( NumberFormatException exp )
        {
            inputDic.put( NUMBER_FORMAT_ERROR_KEY, simultaneousDonwnloadsTF );
            setInputValid( inputDic, false );
            return;
        }

        try
        {
            String downloadsPerHostStr = donwnloadsPerHostTF.getText();
            Integer downloadsPerHost = new Integer( downloadsPerHostStr );
            inputDic.put( DOWNLOADS_PER_HOST_KEY, downloadsPerHost );
        }
        catch ( NumberFormatException exp )
        {
            inputDic.put( NUMBER_FORMAT_ERROR_KEY, donwnloadsPerHostTF );
            setInputValid( inputDic, false );
            return;
        }
        setInputValid( inputDic, true );
    }

    /**
     * When isInputValid() returns a false this method is called.
     * The input dictionary should contain the settings pane specific information
     * of the error.
     * The settings pane should override this method to display a error
     * message. Before calling the method the focus is given to the
     * settings pane.
     */
    public void displayErrorMessage( HashMap inputDic )
    {
        if ( inputDic.containsKey( NUMBER_FORMAT_ERROR_KEY ) )
        {
            displayNumberFormatError( inputDic );
        }
    }

    /**
     * Override this method if you like to apply and save changes made on
     * settings pane. To trigger saving of the configuration if any value was
     * changed call triggerConfigSave().
     */
    public void saveAndApplyChanges( HashMap inputDic )
    {
        Integer simultaneousDownloadsInt = (Integer) inputDic.get(
            SIMULTANEOUS_DOWNLOADS_KEY );
        int simultaneousDownloads = simultaneousDownloadsInt.intValue();
        if ( ServiceManager.sCfg.mMaxDownload != simultaneousDownloads )
        {
            ServiceManager.sCfg.mMaxDownload = simultaneousDownloads;
            OptionsSettingsPane.triggerConfigSave( inputDic );
        }

        Integer downloadsPerHostInt = (Integer) inputDic.get(
            DOWNLOADS_PER_HOST_KEY );
        int downloadsPerHost = downloadsPerHostInt.intValue();
        if ( ServiceManager.sCfg.mMaxDownloadPerIP != downloadsPerHost )
        {
            ServiceManager.sCfg.mMaxDownloadPerIP = downloadsPerHost;
            OptionsSettingsPane.triggerConfigSave( inputDic );
        }

        boolean removeCompletedDownloads = removeCompletedDownloadsChkbx.isSelected();
        if ( ServiceManager.sCfg.mDownloadAutoRemoveCompleted !=
             removeCompletedDownloads )
        {
            ServiceManager.sCfg.mDownloadAutoRemoveCompleted = removeCompletedDownloads;
            OptionsSettingsPane.triggerConfigSave( inputDic );
        }
    }
}