/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Gregor Koukkoullis ( phex@kouk.de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex.gui.dialogs.options;

import java.awt.*;
import javax.swing.*;
import phex.gui.common.*;
import phex.utils.Localizer;

public class GeneralTextPane extends OptionsSettingsPane
{
    private String headerText;
    private String contentText;

    public GeneralTextPane( String aHeaderText, String aContentText,
        String treeRepresentation )
    {
        super( treeRepresentation );
        headerText = aHeaderText;
        contentText = aContentText;
    }

    protected void prepareComponent()
    {
        GridBagConstraints constraints;
        setLayout( new GridBagLayout() );
        setBorder( BorderFactory.createTitledBorder(
            BorderFactory.createEtchedBorder(), Localizer.getString(
            headerText ) ) );

        MultiLinePanel generalLines = new MultiLinePanel(
            Localizer.getString( contentText ) );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.weightx = 1;
            constraints.weighty = 1;
        add( generalLines, constraints );
    }
}