/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Gregor Koukkoullis ( phex@kouk.de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex.gui.models;

import java.util.*;
import javax.swing.table.*;

import phex.query.Search;
import phex.MainFrame;
import phex.download.RemoteFile;
import phex.gui.renderer.*;

/**
 * The table model for the search result table in the search tab.
 * @author Gregor Koukkoullis ( phex@kouk.de )
 */
public class SearchTableModel extends AbstractTableModel
{    
    private static final int numColSharingHost = 0;
    private static final int numColFile = 1;
    private static final int numColExtension = 2;
    private static final int numColSize = 3;
    private static final int numColScore = 4;
    private static final int numColHostSpeed = 5;
    
    private static String[] tableColumns =
    {
        "Sharing Host",
        "File",
        "Extension",
        "Size",
        "Score",
        "Host Speed"
    };

    private MainFrame frame;

    public SearchTableModel( MainFrame aFrame )
    {
        frame = aFrame;
    }

    /*public void setSearch( Search aSearch )
    {
        search = aSearch;
    }*/

    public String getColumnName(int col)
    {
        return tableColumns[ col ];
    }

    public int getColumnCount()
    {
        return tableColumns.length;
    }

    public int getRowCount()
    {
        Search search = frame.getSearchTab().getSelectedSearchResult();
        if (search == null)
        {
            return 0;
        }
        return search.getQueryHitCount();
    }

    public Object getValueAt(int row, int col)
    {
        Search search = frame.getSelectedSearchResult();
        if (search == null)
        {
            return "";
        }

        if ( row >= search.getQueryHitCount() )
        {
            return "";
        }

        RemoteFile rfile = search.getQueryHit( row );
        switch (col)
        {
            case numColSharingHost:
                return rfile.getRemoteHost();
                
            case numColFile:
                return rfile.getShortname();
                
            case numColExtension:
                return rfile.getFileExt() + (rfile.isInDownloadQueue() ? " *" : "");
                
            case numColSize:
                return rfile.getFileSizeLong();
                
            case numColScore:
                return rfile.getScore();
                
            case numColHostSpeed:
                return rfile.getSpeedInt();
        }
        return "";
    }

    public void setValueAt(Object value, int row, int col)
    {
        // Do nothing
    }


    public boolean isCellEditable(int row, int col)
    {
        return false;
    }


    public Class getColumnClass(int col)
    {
        switch (col)
        {
            case numColSharingHost:
                return IPCellRenderer.class;
                
            case numColFile:
                return String.class;
                
            case numColExtension:
                return String.class;
                
            case numColSize:
                return Long.class;
                
            case numColScore:
                return Short.class;
                
            case numColHostSpeed:
                return Integer.class;
        }
        return String.class;
    }
}
