/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Gregor Koukkoullis ( phex@kouk.de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex.gui.models;

import javax.swing.table.*;
import javax.swing.event.*;
import phex.ServiceManager;
import phex.event.UploadFilesChangeListener;
import phex.share.UploadFile;
import phex.share.UploadFileContainer;
import phex.common.TransferDataProvider;
import phex.utils.StrUtil;
import phex.gui.common.LazyEventQueue;
import phex.gui.renderer.*;

public class UploadFilesTableModel extends AbstractTableModel
{
    private final static int colNumDownloadingHost = 0;
    private final static int colNumClient = 1;
    private final static int colNumFile = 2;
    private final static int colNumPercent = 3;
    private final static int colNumSize = 4;
    private final static int colNumRate = 5;
    private final static int colNumStatus = 6;
    
    private final static String[] tableColumns =
    {
        "Downloading Host",
        "Client",
        "File",
        "%",
        "Size",
        "Rate",
        "Status"
    };

    private UploadFileContainer uploadFiles;

    public UploadFilesTableModel()
    {
        uploadFiles = ServiceManager.getShareManager().getUploadFileContainer();
        uploadFiles.addUploadFilesChangeListener( new UploadFilesListener() );
    }

    public String getColumnName(int col)
    {
        return tableColumns[ col ];
    }

    public int getColumnCount()
    {
        return tableColumns.length;
    }

    public int getRowCount()
    {
        return uploadFiles.getUploadListSize();
    }

    public Object getValueAt( int row, int col )
    {
        UploadFile uploadFile = uploadFiles.getUploadFileAt( row );
        if ( uploadFile == null )
        {
            fireTableRowsDeleted( row, row );
            return "";
        }

        switch ( col )
        {
            case colNumDownloadingHost:
                return uploadFile.getRemoteHost();
                
            case colNumClient:
               if (uploadFile.getRemoteAppName() == null)
                       return "";
               else
                       return uploadFile.getRemoteAppName();
               
            case colNumFile:
                return uploadFile.getFilename();
                
            case colNumPercent:
                return uploadFile.getProgress();
                
            case colNumSize:
                return uploadFile;
            
            case colNumRate:
                return uploadFile;
            
            case colNumStatus:
                return uploadFile.getStatusName();
        }
        
        return "";
    }

    public Class getColumnClass(int col)
    {
        switch ( col )
        {
            case colNumPercent:
                return ProgressCellRenderer.class;
                
            case colNumSize:
                return TransferSizeCellRenderer.class;
                
            case colNumRate:
                return TransferRateCellRenderer.class;
        }
        
        return String.class;
    }

    public void fireTableChanged( TableModelEvent event )
    {
        super.fireTableChanged( event );
    }

    private class UploadFilesListener
        implements UploadFilesChangeListener
    {
        private LazyEventQueue lazyEventQueue;

        public UploadFilesListener()
        {
            lazyEventQueue = ServiceManager.getLazyEventQueue();
        }

        public void uploadFileChanged( final int position )
        {
            lazyEventQueue.addTableModelEvent(
                new TableModelEvent( UploadFilesTableModel.this, position, position,
                    TableModelEvent.ALL_COLUMNS, TableModelEvent.UPDATE ) );
        }

        public void uploadFileAdded( final int position )
        {
            fireTableChanged(
                new TableModelEvent(UploadFilesTableModel.this, position, position,
                    TableModelEvent.ALL_COLUMNS, TableModelEvent.INSERT ) );
        }

        public void uploadFileRemoved( final int position )
        {
            fireTableChanged(
                new TableModelEvent(UploadFilesTableModel.this, position, position,
                    TableModelEvent.ALL_COLUMNS, TableModelEvent.DELETE ) );
        }
    }
}