/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Gregor Koukkoullis ( phex@kouk.de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex.gui.renderer;

import java.awt.*;
import javax.swing.*;
import javax.swing.table.DefaultTableCellRenderer;

import phex.common.TransferDataProvider;
import phex.utils.StrUtil;

public class TransferRateCellRenderer extends DefaultTableCellRenderer
{
    public Component getTableCellRendererComponent(JTable table, Object value,
        boolean isSelected, boolean hasFocus, int row, int column)
    {
        super.getTableCellRendererComponent(table, value,
            isSelected, hasFocus, row, column);

        if ( value instanceof TransferDataProvider )
        {
            TransferDataProvider provider = (TransferDataProvider) value;

            CellColorHandler.applyCellColor( provider, this );

            long transferredSize = provider.getTransferredDataSize();
            long totalTransferSize = provider.getTransferDataSize();
            long transferTime = provider.getTransferTimeInSeconds();

            int shortTermTransferRate = provider.getDataTransferRate();
            double averageTransferRate = (double)( transferredSize / (transferTime + 1) );
            long timeRemaining = (long)((totalTransferSize - transferredSize) / (averageTransferRate + 1));

            StringBuffer buffer = new StringBuffer();
            
            // "Instantaneous" transfer rate
            buffer.append( shortTermTransferRate );
            buffer.append( "/Sec, " );
            
            // Average transfer rate
            buffer.append( (int)averageTransferRate );
            buffer.append( "/Sec avg, " );
            
            // Estimated time until completion
            buffer.append( StrUtil.formatSignificantElapsedTime( timeRemaining ) );
            buffer.append( " left" );
 
            setText( buffer.toString() );
        }
        return this;
    }
}