/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2000 William W. Wong
 *  williamw@jps.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package phex.interfaces;

import phex.msg.MsgHeader;

/*
 * Something tells me that computerHeaderLen() should be an internal function,
 * I don't think external objects should be telling a message when it needs to
 * computer its own length if it isn't returning any sort of value. -Mike
 */

/**
 * A Gnutella network message.
 */
public interface IMsg
{
	/** Returns this message's header. */
	public MsgHeader getHeader();
	
	/** Computes the message's header length for internal use. */
	public void computeHeaderLen();
	
	/** Returns the size of the message in bytes. */
	public int getSize();
	
	/**
	 * Writes the message in byte format to the given array, starting at
	 * the given offset.
	 */
	public int serialize (byte[] outbuf, int offset)
		throws Exception;
	
	/**
	 * Reads in the message from the given array, starting at
	 * the given offset.
	 */
	public int deserialize (byte[] inbuf, int offset)
		throws Exception;
}


