
/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Gregor Koukkoullis ( phex@kouk.de )
 *  Copyright (C) 2000 William W. Wong
 *  williamw@jps.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package phex.msg;


import java.net.*;

import phex.*;
import phex.interfaces.*;
import phex.msg.*;
import phex.utils.*;


public class MsgInitResponse implements IMsg
{
    private static final int sDataLength = 14;

    private MsgHeader mHeader;
    private short mPort;
    private byte[] mIP;
    private int mFileCount;
    private int mTotalSize;

    public MsgInitResponse(MsgHeader header)
    {
        setHeader(header);
        mPort = 0;
        mIP = null;
        mFileCount = 0;
        mTotalSize = 0;
    }

    public void setHeader(MsgHeader header)
    {
        mHeader = header;
        mHeader.setFunction(MsgHeader.sInitResponse);
    }

    public MsgHeader getHeader()
    {
        return mHeader;
    }


    public void setPort(short Port)
    {
        this.mPort = Port;
    }


    public short getPort()
    {
        return mPort;
    }


    public void setIP(byte[] ip)
    {
        mIP = ip;
    }


    public byte[] getIP()
    {
        return mIP;
    }


    public void setFileCount(int FileCount)
    {
        this.mFileCount = FileCount;
    }


    public int getFileCount()
    {
        return mFileCount;
    }


    public void setTotalSize(int TotalSize)
    {
        this.mTotalSize = TotalSize;
    }


    public int getTotalSize()
    {
        return mTotalSize;
    }





    public void computeHeaderLen()
    {
        mHeader.setDataLen(getSize() - mHeader.getSize());
    }


    public int getSize()
    {
        return mHeader.getSize() + sDataLength;
    }


    public void copy(MsgInitResponse b)
    {
        mHeader.copy(b.getHeader());
        mPort = b.mPort;
        mIP = b.mIP;
        mFileCount = b.mFileCount;
        mTotalSize = b.mTotalSize;
    }


    public int serialize(byte[] outbuf, int offset)
            throws Exception
    {
        offset = mHeader.serialize(outbuf, offset);
        offset = IOUtil.serializeShortLE(mPort, outbuf, offset);	// Convert to Intel little-endian
        System.arraycopy(mIP, 0, outbuf, offset, 4);
        offset += 4;
        offset = IOUtil.serializeIntLE(mFileCount, outbuf, offset);	// Convert to Intel little-endian
        offset = IOUtil.serializeIntLE(mTotalSize, outbuf, offset);	// Convert to Intel little-endian

        return offset;
    }


    public int deserialize(byte[] inbuf, int offset)
            throws Exception
    {
        // Already read the header.
        mPort = IOUtil.deserializeShortLE(inbuf, offset);
        offset += 2;
        StringBuffer strBuf = new StringBuffer();
        // TODO this IP parsing can be improved much!
        offset = IOUtil.deserializeIP(inbuf, offset, strBuf);
        mIP = InetAddress.getByName(strBuf.toString()).getAddress();
        mFileCount = IOUtil.deserializeIntLE(inbuf, offset);
        offset += 4;
        mTotalSize = IOUtil.deserializeIntLE(inbuf, offset);
        offset += 4;

        return offset;
    }


    public String toString()
    {
        return	"[" +
                mHeader + " " +
                "Port=" + mPort + ", " +
                "IP=" + IPUtils.ip2string( mIP ) + ", " +
                "FileCount=" + mFileCount + ", " +
                "TotalSize=" + mTotalSize +
                "]";
    }
}

