
/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2000 William W. Wong
 *  williamw@jps.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package phex.msg;


import java.net.*;

import phex.*;
import phex.interfaces.*;
import phex.utils.*;


public class MsgQuery implements IMsg
{
    private MsgHeader mHeader;
    private Short minSpeed;
    private String mSearchString;


    public MsgQuery()
    {
        this( new MsgHeader() );
    }

    public MsgQuery(MsgHeader header)
    {
        setHeader(header);
        minSpeed = new Short( (short)0 );
        mSearchString = "";
    }


    public void setHeader(MsgHeader header)
    {
        mHeader = header;
        mHeader.setFunction(MsgHeader.sQuery);
    }


    public MsgHeader getHeader()
    {
        return mHeader;
    }


    public void setMinSpeed(short aMinSpeed)
    {
        minSpeed = new Short( aMinSpeed );
    }


    public short getMinSpeed()
    {
        return minSpeed.shortValue();
    }

    public Short getMinSpeedObject()
    {
        return minSpeed;
    }

    public void setSearchString(String search)
    {
        this.mSearchString = search;
    }

    public String getSearchString()
    {
        return mSearchString;
    }

    public void computeHeaderLen()
    {
        mHeader.setDataLen(getSize() - mHeader.getSize());
    }


    public int getSize()
    {
        return mHeader.getSize() + 2 + mSearchString.length() + 1;	// plus 1 for the ending 0.
    }


    public void copy(MsgQuery b)
    {
        mHeader.copy(b.getHeader());
        minSpeed = b.minSpeed;
        mSearchString = b.mSearchString;
    }


    public int serialize(byte[] outbuf, int offset)
            throws Exception
    {
        offset = mHeader.serialize(outbuf, offset);
        offset = IOUtil.serializeShortLE(minSpeed.shortValue(), outbuf, offset);
        offset = IOUtil.serializeString(mSearchString, outbuf, offset);
        outbuf[offset++] = 0;

        return offset;
    }


    public int deserialize(byte[] inbuf, int offset)
            throws Exception
    {
        // Already read the header.
        minSpeed = new Short( IOUtil.deserializeShortLE(inbuf, offset) );
        offset += 2;
        StringBuffer	buf = new StringBuffer();
        offset = IOUtil.deserializeString(inbuf, offset, buf);
        if (offset < inbuf.length && inbuf[offset] == 0)
            offset++;					// skip terminating 0.
        mSearchString = buf.toString();

        return offset;
    }


    public String toString()
    {
        return	"[" +
                mHeader + " " +
                "MinSpeed=" + minSpeed.shortValue() + ", " +
                "SearchString=" + mSearchString +
                "]";
    }


}

