
/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2000 William W. Wong
 *  williamw@jps.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package phex.msg;


import java.net.*;

import phex.*;
import phex.utils.*;


public class MsgResRecord
{
    private int		mFileIndex = 0;
    private String	fileName = "";
    private int		mFileSize = 0;

    public MsgResRecord()
    {
    }

    public MsgResRecord(int fileIndex, int fileSize, String aFileName)
    {
        mFileIndex = fileIndex;
        mFileSize = fileSize;
        fileName = aFileName;
    }


    public void setFileIndex(int fileIndex)
    {
        mFileIndex = fileIndex;
    }


    public int getFileIndex()
    {
        return mFileIndex;
    }


    public int getFileSize()
    {
        return mFileSize;
    }


    public void setFileSize(int FileSize)
    {
        this.mFileSize = FileSize;
    }


    public String getFilename()
    {
        return fileName;
    }


    public void setFilename(String Filename)
    {
        this.fileName = Filename;
    }




    public int getSize()
    {
        return 8 + fileName.length() + 2;	// plus 2 for 2 ending 0's
    }


    public void copy(MsgResRecord b)
    {
        mFileIndex = b.mFileIndex;
        mFileSize = b.mFileSize;
        fileName = b.fileName;
    }


    public int serialize(byte[] outbuf, int offset)
    {
        offset = IOUtil.serializeIntLE(mFileIndex, outbuf, offset);	// Convert to Intel little-endian
        offset = IOUtil.serializeIntLE(mFileSize, outbuf, offset);	// Convert to Intel little-endian
        offset = IOUtil.serializeString(fileName, outbuf, offset);
        outbuf[offset++] = 0;	// 2 ending 0's
        outbuf[offset++] = 0;

        return offset;
    }


    public int deserialize(byte[] inbuf, int offset)
            //throws Exception
    {
        mFileIndex = IOUtil.deserializeIntLE(inbuf, offset);
        offset += 4;
        mFileSize = IOUtil.deserializeIntLE(inbuf, offset);
        offset += 4;

        // Handle Gnotella termination of single null terminated file names right
        // this prevents strange results like a filename of 44khz which is meta
        // data of gnotella.
        // search for first null terminator
        int firstTerminatorIdx = offset;
        while ( inbuf[firstTerminatorIdx] != (byte) 0 )
        {
            firstTerminatorIdx++;
        }

        // extract the file name
        fileName = new String( inbuf, offset, firstTerminatorIdx - offset);

        int secondTerminatorIdx = firstTerminatorIdx + 1; // skip terminator
        //Find second null terminator.
        while ( inbuf[secondTerminatorIdx] != (byte) 0 )
        {
            secondTerminatorIdx++;
        }
/*
        // parse out meta data description ( like 44kHZ for mp3 )
        String description = new String( inbuf, firstTerminatorIdx + 1,
            secondTerminatorIdx - firstTerminatorIdx );
*/
        // skip second terminator
        offset = secondTerminatorIdx + 1;

        return offset;
    }


    public String toString()
    {
        return	"[" +
                "FileIndex=" + mFileIndex + ", " +
                "FileSize=" + mFileSize + ", " +
                "Filename=" + fileName +
                "]";
    }

}

