/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Gregor Koukkoullis ( phex@kouk.de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package phex.query;

import phex.FQueue;
import phex.ServiceManager;
import phex.msg.MsgQuery;
import phex.config.Cfg;
import phex.event.QueryHistoryChangeListener;

public class QueryHistoryMonitor
{
    private Cfg configuration;
    private FQueue historyQueue;

    /**
     * Right now we have only one single listener. If more are needed apply
     * the same design that can be found in NetworkHostContainer
     */
    private QueryHistoryChangeListener changeListener;

    public QueryHistoryMonitor()
    {
        configuration = ServiceManager.sCfg;
        historyQueue = new FQueue( configuration.searchHistoryLength );
    }

    public void setHistoryMonitored( boolean state )
    {
        configuration.monitorSearchHistory = state;
        configuration.save();
    }

    public boolean isHistoryMonitored( )
    {
        return configuration.monitorSearchHistory;
    }

    public synchronized void setMaxHistroySize( int size )
    {
        if ( size == historyQueue.getMax() )
        {
            return;
        }
        historyQueue.resize( size );
        configuration.searchHistoryLength = size;
        configuration.save();
    }

    public synchronized int getMaxHistorySize()
    {
        return historyQueue.getMax();
    }

    public synchronized int getHistorySize()
    {
        return historyQueue.getCount();
    }

    public synchronized MsgQuery getSearchQueryAt( int index )
    {
        return (MsgQuery) historyQueue.getAt( index );
    }

    public synchronized void addSearchQuery( MsgQuery query )
    {
        if ( configuration.monitorSearchHistory )
        {
            historyQueue.add( query );
            fireQueryHistoryChanged( );
        }
    }

    ///////////////////// START event handling methods ////////////////////////
    public void setQueryHistoryChangeListener( QueryHistoryChangeListener listener )
    {
        if ( changeListener != null )
        {
            throw new RuntimeException( "CaughtHostChangedListener already used!!" );
        }
        changeListener = listener;
    }

    private void fireQueryHistoryChanged( )
    {
        changeListener.queryHistoryChanged( );
    }
    ///////////////////// END event handling methods ////////////////////////
}