/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Gregor Koukkoullis ( phex@kouk.de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex.query;

public class QueryManager
{
    private QueryHistoryMonitor queryMonitor;
    private SearchContainer searchContainer;
    private BackgroundSearchContainer backgroundSearchContainer;
    private ResearchService researchService;

    public QueryManager()
    {
        queryMonitor = new QueryHistoryMonitor();
        searchContainer = new SearchContainer();
        backgroundSearchContainer = new BackgroundSearchContainer();
        researchService = new ResearchService( new ResearchServiceConfig() );
    }

    public QueryHistoryMonitor getQueryHistoryMonitor()
    {
        return queryMonitor;
    }

    public SearchContainer getSearchContainer()
    {
        return searchContainer;
    }

    public BackgroundSearchContainer getBackgroundSearchContainer()
    {
        return backgroundSearchContainer;
    }

    public ResearchService getResearchService()
    {
        return researchService;
    }

    /**
     * Stops all searches where the timeout has passed.
     */
    public void stopExpiredSearches()
    {
        long currentTime = System.currentTimeMillis();
        searchContainer.stopExpiredSearches( currentTime );
        backgroundSearchContainer.stopExpiredSearches( currentTime );
    }
}