
/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2000 William W. Wong
 *  williamw@jps.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package phex.share;


import java.io.*;
import java.util.*;

import phex.interfaces.*;



public class IndexerMP3 implements IFileIndexer
{
	public static String[]	sGenre;

	static
	{
		sGenre = new String[116];

		sGenre[0] = "";
		sGenre[1] = "Blues";
		sGenre[2] = "Classic Rock";
		sGenre[3] = "Country";
		sGenre[4] = "Dance";
		sGenre[5] = "Disco";
		sGenre[6] = "Funk";
		sGenre[7] = "Grunge";
		sGenre[8] = "Hip-Hop";
		sGenre[9] = "Jazz";
		sGenre[10] = "Metal";
		sGenre[11] = "New Age";
		sGenre[12] = "Oldies";
		sGenre[13] = "Other";
		sGenre[14] = "Pop";
		sGenre[15] = "R&B";
		sGenre[16] = "Rap";
		sGenre[17] = "Reggae";
		sGenre[18] = "Rock";
		sGenre[19] = "Techno";
		sGenre[20] = "Industrial";
		sGenre[21] = "Alternative";
		sGenre[22] = "Ska";
		sGenre[23] = "Death Metal";
		sGenre[24] = "Pranks";
		sGenre[25] = "Soundtrack";
		sGenre[26] = "Euro-Techno";
		sGenre[27] = "Ambient";
		sGenre[28] = "Trip-Hop";
		sGenre[29] = "Vocal";
		sGenre[30] = "Jazz+Funk";
		sGenre[31] = "Fusion";
		sGenre[32] = "Trance";
		sGenre[33] = "Classical";
		sGenre[34] = "Instrumental";
		sGenre[35] = "Acid";
		sGenre[36] = "House";
		sGenre[37] = "Game";
		sGenre[38] = "Sound Clip";
		sGenre[39] = "Gospel";
		sGenre[40] = "Noise";
		sGenre[41] = "AlternRock";
		sGenre[42] = "Bass";
		sGenre[43] = "Soul";
		sGenre[44] = "Punk";
		sGenre[45] = "Space";
		sGenre[46] = "Meditative";
		sGenre[47] = "Instrumental Pop";
		sGenre[48] = "Instrumental Rock";
		sGenre[49] = "Ethnic";
		sGenre[50] = "Gothic";
		sGenre[51] = "Darkwave";
		sGenre[52] = "Techno-Industrial";
		sGenre[53] = "Electronic";
		sGenre[54] = "Pop-Folk";
		sGenre[55] = "Eurodance";
		sGenre[56] = "Dream";
		sGenre[57] = "Southern Rock";
		sGenre[58] = "Comedy";
		sGenre[59] = "Cult";
		sGenre[60] = "Gangsta";
		sGenre[61] = "Top 40";
		sGenre[62] = "Christian Rap";
		sGenre[63] = "Pop/Funk";
		sGenre[64] = "Jungle";
		sGenre[65] = "Native American";
		sGenre[66] = "Cabaret";
		sGenre[67] = "New Wave";
		sGenre[68] = "Psychadelic";
		sGenre[69] = "Rave";
		sGenre[70] = "Showtunes";
		sGenre[71] = "Trailer";
		sGenre[72] = "Lo-Fi";
		sGenre[73] = "Tribal";
		sGenre[74] = "Acid Punk";
		sGenre[75] = "Acid Jazz";
		sGenre[76] = "Polka";
		sGenre[77] = "Retro";
		sGenre[78] = "Musical";
		sGenre[79] = "Rock & Roll";
		sGenre[80] = "Hard Rock";
		sGenre[81] = "Folk";
		sGenre[82] = "Folk/Rock";
		sGenre[83] = "National Folk";
		sGenre[84] = "Swing";
		sGenre[85] = "Bebob";
		sGenre[86] = "Latin";
		sGenre[87] = "Revival";
		sGenre[88] = "Celtic";
		sGenre[89] = "Bluegrass";
		sGenre[90] = "Avantgarde";
		sGenre[91] = "Gothic Rock";
		sGenre[92] = "Progressive Rock";
		sGenre[93] = "Psychedelic Rock";
		sGenre[94] = "Symphonic Rock";
		sGenre[95] = "Slow Rock";
		sGenre[96] = "Big Band";
		sGenre[97] = "Chorus";
		sGenre[98] = "Easy Listening";
		sGenre[99] = "Acoustic";
		sGenre[100] = "Humour";
		sGenre[101] = "Speech";
		sGenre[102] = "Chanson";
		sGenre[103] = "Opera";
		sGenre[104] = "Chamber Music";
		sGenre[105] = "Sonata";
		sGenre[106] = "Symphony";
		sGenre[107] = "Booty Bass";
		sGenre[108] = "Primus";
		sGenre[109] = "Porn Groove";
		sGenre[110] = "Satire";
		sGenre[111] = "Slow Jam";
		sGenre[112] = "Club";
		sGenre[113] = "Tango";
		sGenre[114] = "Samba";
		sGenre[115] = "Folklore";

	}
	
	
	private byte[]			mBuf = new byte[128];


	public Hashtable index(File file)
			throws Exception
	{
		Hashtable			words = new Hashtable();
		RandomAccessFile	fis = new RandomAccessFile(file, "r");

		if (fis.length() < 128)
			return words;

		fis.seek(fis.length() - 128);
		fis.read(mBuf);

		if (mBuf[0] != (byte)'T' || mBuf[1] != (byte)'A' || mBuf[2] != (byte)'G')
		{
			return words;
		}

		String	song = new String(mBuf, 3, 30).trim().toUpperCase();
		String	artist = new String(mBuf, 33, 30).trim().toUpperCase();
		String	album = new String(mBuf, 63, 30).trim().toUpperCase();
		String	year = new String(mBuf, 93, 4).trim().toUpperCase();
		String	comment = new String(mBuf, 97, 30).trim().toUpperCase();
		String	genre = "";
		int		genreCode = (int)mBuf[127];
		if (genreCode < 0)
			genreCode += 128;
		if (genreCode < sGenre.length)
			genre = sGenre[genreCode];

		addWords(words, song);
		addWords(words, artist);
		addWords(words, album);
		words.put(year, "");
		addWords(words, comment);
		addWords(words, genre);

		return words;
	}


	private void addWords(Hashtable words, String str)
	{
		StringTokenizer	tokens = new StringTokenizer(str);

		while (tokens.hasMoreTokens())
		{
			words.put(tokens.nextToken(), "");
		}
	}



	public static void main(String[] args)
	{
		try
		{
			IndexerMP3	indexer = new IndexerMP3();
			File		file = new File(args[0]);

			System.out.println(indexer.index(file));
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}


}


