
/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2000 William W. Wong
 *  williamw@jps.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package phex.share;


import java.util.*;
import java.io.*;

import phex.ServiceManager;
import phex.Res;
import phex.interfaces.*;


public class IndexerManager
{
    private ServiceManager		mManager;
    private Hashtable			mIndexers = new Hashtable();


    private IndexerManager()
    {
        // disable
    }


    public IndexerManager(ServiceManager manager)
    {
        mManager = manager;
        //loadIndexClasses();
    }


    /*public void loadIndexClasses()
    {
        IFileIndexer	indexerObj;
        String			indexers = Res.getStr("indexers");

        if (indexers != null)
        {
            StringTokenizer	tokens = new StringTokenizer(indexers);

            // Go through the menu items
            while (tokens.hasMoreTokens())
            {
                String	indexer = tokens.nextToken();
                String	filetype = Res.getStr(indexer + ".filetype");
                String	className = Res.getStr(indexer + ".class");

                if (filetype == null || className == null)
                    continue;

                try
                {
                    indexerObj = (IFileIndexer)Class.forName(className).newInstance();
                    StringTokenizer	types = new StringTokenizer(filetype);
                    while (types.hasMoreElements())
                    {
                        mIndexers.put(types.nextToken().toUpperCase(), indexerObj);
                    }
                }
                catch (Exception e)
                {
                    e.printStackTrace();
                    continue;
                }
            }
        }
    }*/


    public Hashtable index(File file, String filetype)
            throws Exception
    {
        IFileIndexer	indexer = (IFileIndexer)mIndexers.get(filetype.toUpperCase());

        if (indexer == null)
            return null;

        return indexer.index(file);
    }


}


