/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Gregor Koukkoullis - phex@kouk.de
 *  Copyright (C) 2000 William W. Wong
 *  williamw@jps.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package phex.share;

import java.io.*;
import java.util.*;
import java.net.*;

import phex.Res;
import phex.ServiceManager;
import phex.share.FileAdministration;
import phex.utils.*;

public class ShareFile
{
    private final static String PHEX_FILE_NAME = StrUtil.getAppNameVersion();
    private int mFileIndex;
    private FileAdministration shareFileAdmin;
    private File file;
    private String fileName;

    /**
     * The absolute file name in lower case for optimization.
     */
    private char[] searchCompareTerm;
    private Long fileSize;
    private Integer searchCount;
    private Integer uploadCount;

    private ShareFile()
    {
        // private
    }

    public ShareFile( File aFile )
    {
        file = aFile;
        if ( file == null )
        {
            mFileIndex = -1;
            fileName = PHEX_FILE_NAME;
            fileSize = new Long( 0 );
        }
        else
        {
            shareFileAdmin = ServiceManager.getShareManager().getFileAdministration();
            searchCount = new Integer( 0 );
            uploadCount = new Integer( 0 );
            fileName = file.getName();
            searchCompareTerm = file.getAbsolutePath().toLowerCase().toCharArray();
            fileSize = new Long( file.length() );
        }
    }

    public File getFile()
    {
        return file;
    }

    public int getFileIndex()
    {
        return mFileIndex;
    }


    public void setFileIndex( int index)
    {
        mFileIndex = index;
    }

    public Long getFileSizeObject()
    {
        return fileSize;
    }

    public long getFileSize()
    {
        return fileSize.longValue();
    }

    public Integer getSearchCountObject()
    {
        return searchCount;
    }

    public int getSearchCount()
    {
        return searchCount.intValue();
    }

    public void incSearchCount( )
    {
        searchCount = new Integer( searchCount.intValue() + 1 );
        shareFileAdmin.fireSharedFileChanged( this );
    }

    public Integer getUploadCountObject()
    {
        return uploadCount;
    }

    public int getUploadCount()
    {
        return uploadCount.intValue();
    }

    public void incUploadCount( )
    {
        uploadCount = new Integer( uploadCount.intValue() + 1 );
        shareFileAdmin.fireSharedFileChanged( this );
    }

    public String getEffectiveName()
    {
        return fileName;
    }

    /**
     * Returns the search compare term in lower case for optimization.
     */
    public char[] getSearchCompareTerm()
    {
        return searchCompareTerm;
    }

    public String toString()
    {
        return super.toString() + fileName + "  " + mFileIndex;
    }
}


