/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Gregor Koukkoullis ( phex@kouk.de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex.update;

import java.net.*;
import phex.Res;
import phex.connection.HTTPURLRequest;
import phex.utils.VersionUtils;
import phex.ServiceManager;
import phex.event.UpdateNotificationListener;

public class UpdateChecker
{
    private static final long ONE_WEEK_MILLIS = 1000 * 60 * 1440 * 7;
    private static final String updateURL = "http://www.kouk.de/phex/update.cfg";
    private String updateVersion;
    private UpdateNotificationListener listener;

    public UpdateChecker( UpdateNotificationListener updateListener )
    {
        listener = updateListener;
    }

    public void setShowUpdateNotification( boolean state )
    {
        ServiceManager.sCfg.showUpdateNotification = state;
        ServiceManager.sCfg.save();
    }

    public String getUpdateVersion()
    {
        return updateVersion;
    }

    public void checkForUpdate()
    {
        if ( ServiceManager.sCfg.lastUpdateCheckTime >
            System.currentTimeMillis() - ONE_WEEK_MILLIS )
        {
            return;
        }

        Thread thread = new Thread( new UpdateCheckRunner(), "UpdateCheckRunner" );
        thread.setDaemon( true );
        thread.start();
    }

    private void fireUpdateNotification()
    {
        listener.updateNotification( this );
    }

    private class UpdateCheckRunner implements Runnable
    {
        public void run()
        {
            URL url;
            try
            {
                url = new URL( updateURL );
            }
            catch ( java.net.MalformedURLException exp )
            {
                exp.printStackTrace();
                throw new RuntimeException( );
            }
            String updateFileContents = HTTPURLRequest.loadPage( url );
            if ( updateFileContents == null )
            {
                return;
            }
            updateFileContents = updateFileContents.trim();
            if ( updateFileContents.length() == 0 )
            {
                return;
            }
            updateVersion = updateFileContents;

            ServiceManager.sCfg.lastUpdateCheckTime = System.currentTimeMillis();

            int val = VersionUtils.compare( updateVersion,
                Res.getStr("Program.Version") );

            // if you have the current version or don't care about a notification
            // the check is done anyway even if you don't want a notification
            // to get an idea of the number of Phex clients in the network.
            if ( val <= 0 || !ServiceManager.sCfg.showUpdateNotification )
            {
                ServiceManager.sCfg.save();
                return;
            }

            val = VersionUtils.compare( updateVersion,
                ServiceManager.sCfg.lastUpdateCheckVersion );
            if ( val > 0 )
            {
                ServiceManager.sCfg.lastUpdateCheckVersion = updateVersion;
                fireUpdateNotification();
            }
            ServiceManager.sCfg.save();
        }
    }
}