
/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Gregor Koukkoullis ( phex@kouk.de )
 *  Copyright (C) 2000 William W. Wong
 *  williamw@jps.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package phex.utils;


import java.io.*;
import java.net.*;


public class IOUtil
{

    public static int serializeIntLE(int value, byte[] outbuf, int offset)
    {
        outbuf[offset++] = (byte)(value);
        outbuf[offset++] = (byte)(value >> 8);
        outbuf[offset++] = (byte)(value >> 16);
        outbuf[offset++] = (byte)(value >> 24);

        // Return next offset.
        return offset;
    }


    public static int deserializeIntLE(byte[] inbuf, int offset)
    {
        return	(inbuf[offset + 3]      ) << 24 |
                (inbuf[offset + 2] &0xff) << 16 |
                (inbuf[offset + 1] &0xff) <<  8 |
                (inbuf[offset]     &0xff);
    }


    public static int serializeShortLE(short value, byte[] outbuf, int offset)
    {
        outbuf[offset++] = (byte)(value);
        outbuf[offset++] = (byte)(value >> 8);

        // Return next offset.
        return offset;
    }


    public static short deserializeShortLE(byte[] inbuf, int offset)
    {
        return	(short)	((inbuf[offset + 1] &0xff) <<  8 |
                         (inbuf[offset]     &0xff));
    }


    public static int unsignedByte2int( byte x )
    {
        return ((int)x) & 0x000000FF;
    }


    public static int serializeString(String str, byte[] outbuf, int offset)
    {
        // Strip off the hi-byte of the char.  No good.
        for (int i = 0; i < str.length(); i++)
        {
            outbuf[offset] = (byte)str.charAt(i);
            offset++;
        }

        return offset;
    }


    public static int deserializeString(byte[] inbuf, int offset, StringBuffer outbuf)
    {
        int		begin = offset;
        int		maxLen = inbuf.length;

        while (offset < maxLen)
        {
            if (inbuf[offset] == 0)
            {
                // Note that the terminating 0 is not added in the returning offset.
                break;
            }
            offset++;
        }
        if (offset-begin > 0)
            outbuf.append(new String(inbuf, begin, offset-begin));

        return offset;
    }


    public static int deserializeString(byte[] inbuf, int offset, int len, StringBuffer outbuf)
    {
        if (len > inbuf.length - offset)
            len = inbuf.length - offset;

        outbuf.append(new String(inbuf, offset, len));
        return offset + len;
    }


    public static int serializeIP(String ip, byte[] outbuf, int offset)
    {
        InetAddress inet = null;
        byte[] addrBuf = null;
        try
        {
            inet = InetAddress.getByName(ip);
            addrBuf = inet.getAddress();
        }
        catch (Exception e)
        {
            addrBuf = new byte[4];
            addrBuf[0] = (byte)'\0';
            addrBuf[1] = (byte)'\0';
            addrBuf[2] = (byte)'\0';
            addrBuf[3] = (byte)'\0';
        }

        outbuf[offset++] = addrBuf[0];
        outbuf[offset++] = addrBuf[1];
        outbuf[offset++] = addrBuf[2];
        outbuf[offset++] = addrBuf[3];

        return offset;
    }


    public static int deserializeIP(byte[] inbuf, int offset, StringBuffer outbuf)
    {
        int	digit1 = inbuf[offset];
        int	digit2 = inbuf[offset+1];
        int	digit3 = inbuf[offset+2];
        int	digit4 = inbuf[offset+3];

        if (digit1 < 0)
            digit1 += 256;
        if (digit2 < 0)
            digit2 += 256;
        if (digit3 < 0)
            digit3 += 256;
        if (digit4 < 0)
            digit4 += 256;

        outbuf.append(digit1).append(".").append(digit2).append(".").append(digit3).append(".").append(digit4);

        return offset + 4;
    }


    public static int readToCRLF(InputStream is, byte[] buf, int bufLen, int offset)
        throws Exception
    {
        boolean isNearEnd = false;

        while (bufLen > 0)
        {
            int	ch = is.read();

            if ( ch == -1 )
            {
                throw new IOException("Connection closed by remote host.");
            }
            buf[offset++] = (byte)ch;
            bufLen--;

            // look for \r\n or \n\n
            if (isNearEnd)
            {
                if (ch == (int)'\n')
                {
                    // minus 2 to remove the \r\n or \n\n.
                    return offset - 2;
                }
                else
                {
                    isNearEnd = false;
                }
            }

            if (ch == (int)'\n' || ch == (int)'\r')
            {
                isNearEnd = true;
            }
        }
        throw new Exception("Out of buffer");
    }


    public static int readToLF(InputStream is, byte[] buf, int bufLen, int offset)
            throws Exception
    {
        while (bufLen > 0)
        {
            int	ch = is.read();

            if (ch == 0|| ch == -1)
            {
                throw new IOException("Connection closed by remote host.");
            }
            buf[offset++] = (byte)ch;
            bufLen--;

            // look for \n
            if (ch == (int)'\n')
            {
                // minus 1 to remove the \n.
                return offset - 1;
            }
        }
        throw new Exception("Out of buffer");
    }


    public static int readToCROrLF(InputStream is, byte[] buf, int bufLen, int offset)
            throws Exception
    {
        while (bufLen > 0)
        {
            int	ch = is.read();

            if (ch == 0|| ch == -1)
            {
                throw new IOException("Connection closed by remote host.");
            }
            buf[offset++] = (byte)ch;
            bufLen--;

            // look for \n
            if (ch == (int)'\n' || ch == (int)'\r')
            {
                // minus 1 to remove the \n.
                return offset - 1;
            }
        }
        throw new Exception("Out of buffer");
    }
}