/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Gregor Koukkoullis ( phex@kouk.de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex.utils;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.MissingResourceException;

/**
 * This class is intended to provide localized strings.
 * Currently it just returns the given string to get the class introduced in
 * the gui.
 */
public class Localizer
{
    private static ResourceBundle bundle;

    static
    {
        try
        {
            bundle = ResourceBundle.getBundle( "phex.resources.Lang" );
        }
        catch ( MissingResourceException exp )
        {
            System.err.println( "phex/resources/Lang.properties not found" );
            System.exit( 1 );
        }
    }

    /**
     * Returns the actual language text out of the resource boundle.
     * If the key is not defined it returns the key itself and prints an
     * error message on system.err.
     */
    public static String getString( String key )
    {
        String value = null;
        try
        {
            value = bundle.getString( key );
        }
        catch ( MissingResourceException exp )
        {
        }
        if ( value == null )
        {
            System.err.println( "Missing language key: " + key );
            value = key;
        }
        return value;
    }

    /**
     * Returns the first character of the actual language text out of the
     * resource boundle. The method can be usefull for getting mnemonics.
     * If the key is not defined it returns the first char of the key itself and
     * prints an error message on system.err.
     */
    public static char getChar( String key )
    {
        String str = getString( key );
        return str.charAt( 0 );
    }

    /**
     * Returns the actual language text out of the resource boundle and formats
     * it accordingly with the given Object array.
     * If the key is not defined it returns the key itself and print an
     * error message on system.err.
     */
   public static String getFormatedString(String key, Object[] obj)
   {
        String value = null;
        try
        {
            value = MessageFormat.format( bundle.getString( key ), obj);
        }
        catch ( MissingResourceException exp )
        {
        }
        if ( value == null )
        {
            System.err.println( "Missing language key: " + key );
            value = key;
        }
        return value;
   }
}