/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Gregor Koukkoullis ( phex@kouk.de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex.xml;

import org.w3c.dom.*;
import javax.xml.parsers.*;
import org.apache.crimson.tree.*;
//import com.sun.xml.tree.*;
import java.util.*;
import java.io.*;
import java.lang.reflect.*;

// Generated by xgen Code Generator from Gregor Koukkoullis
// DO NOT edit this class !
public abstract class XMLDownloadFileXMLCodec
{
    public static XmlDocument encodeXML(XMLDownloadFile object )
    {
        XmlDocument doc = XMLBuilder.createNewDocument();
        encodeXML( object, doc, doc );
        return doc;
    }

    public static void encodeXML(XMLDownloadFile object, Node parentNode, Document doc )
    {
        Element topElem = doc.createElement( "downloadfile" );
        parentNode.appendChild( topElem );

        Object filename = object.getFilename();
        if ( filename != null )
        {
            String s = filename.toString();
            if ( s.length() > 0 )
            {
                Element filenameElm = doc.createElement( "filename" );
                filenameElm.appendChild( doc.createTextNode( s ) );
                topElem.appendChild( filenameElm );
            }
        }

        Object localFilename = object.getLocalFilename();
        if ( localFilename != null )
        {
            String s = localFilename.toString();
            if ( s.length() > 0 )
            {
                Element localFilenameElm = doc.createElement( "localfilename" );
                localFilenameElm.appendChild( doc.createTextNode( s ) );
                topElem.appendChild( localFilenameElm );
            }
        }

        Object searchterm = object.getSearchterm();
        if ( searchterm != null )
        {
            String s = searchterm.toString();
            if ( s.length() > 0 )
            {
                Element searchtermElm = doc.createElement( "searchterm" );
                searchtermElm.appendChild( doc.createTextNode( s ) );
                topElem.appendChild( searchtermElm );
            }
        }

        Element filesizeElm = doc.createElement( "filesize" );
        filesizeElm.appendChild( doc.createTextNode( String.valueOf( object.getFilesize() ) ) );
        topElem.appendChild( filesizeElm );

        Object status = object.getStatus();
        if ( status != null )
        {
            String s = status.toString();
            if ( s.length() > 0 )
            {
                Element statusElm = doc.createElement( "status" );
                statusElm.appendChild( doc.createTextNode( s ) );
                topElem.appendChild( statusElm );
            }
        }


        Iterator remoteFileList = object.createXMLRemoteFileIterator();
        if ( remoteFileList.hasNext() )
        {
            phex.xml.XMLRemoteFile obj;
            while ( remoteFileList.hasNext() )
            {
                obj = (phex.xml.XMLRemoteFile) remoteFileList.next();
                XMLRemoteFileXMLCodec.encodeXML( obj, topElem, doc );
            }
        }

    }

    public static XMLDownloadFile decodeXML( Element root )
    {
        // create new instance
        XMLDownloadFile instance = new XMLDownloadFile();

        NodeList filenameList = root.getChildNodes();
        int lengthfilename = filenameList.getLength();
        for (int i = 0; i < lengthfilename; i++ )
        {
            Node filename = filenameList.item( i );
            if ( filename != null && filename.getNodeType() == Node.ELEMENT_NODE &&
                 filename.getNodeName().equals( "filename" ) )
            {
                String filenameValue = getText( (Element)filename);
                instance.setFilename( filenameValue );
                break;
            }
        }

        NodeList localFilenameList = root.getChildNodes();
        int lengthlocalFilename = localFilenameList.getLength();
        for (int i = 0; i < lengthlocalFilename; i++ )
        {
            Node localFilename = localFilenameList.item( i );
            if ( localFilename != null && localFilename.getNodeType() == Node.ELEMENT_NODE &&
                 localFilename.getNodeName().equals( "localfilename" ) )
            {
                String localFilenameValue = getText( (Element)localFilename);
                instance.setLocalFilename( localFilenameValue );
                break;
            }
        }


        NodeList searchtermList = root.getChildNodes();
        int lengthsearchterm = searchtermList.getLength();
        for (int i = 0; i < lengthsearchterm; i++ )
        {
            Node searchterm = searchtermList.item( i );
            if ( searchterm != null && searchterm.getNodeType() == Node.ELEMENT_NODE &&
                 searchterm.getNodeName().equals( "searchterm" ) )
            {
                String searchtermValue = getText( (Element)searchterm);
                instance.setSearchterm( searchtermValue );
                break;
            }
        }

        NodeList filesizeList = root.getChildNodes();
        int lengthfilesize = filesizeList.getLength();
        for (int i = 0; i < lengthfilesize; i++ )
        {
            Node filesize = filesizeList.item( i );
            if ( filesize != null && filesize.getNodeType() == Node.ELEMENT_NODE &&
                 filesize.getNodeName().equals( "filesize" ) )
            {
                String filesizeValue = getText( (Element)filesize);
                instance.setFilesize( Long.parseLong( filesizeValue ) );
                break;
            }
        }

        NodeList statusList = root.getChildNodes();
        int lengthstatus = statusList.getLength();
        for (int i = 0; i < lengthstatus; i++ )
        {
            Node status = statusList.item( i );
            if ( status != null && status.getNodeType() == Node.ELEMENT_NODE &&
                 status.getNodeName().equals( "status" ) )
            {
                String statusValue = getText( (Element)status);
                instance.setStatus( statusValue );
                break;
            }
        }

        NodeList remoteFileListList = root.getChildNodes();
        int lengthremoteFileList = remoteFileListList.getLength();
        for (int i = 0; i < lengthremoteFileList; i++ )
        {
            Node remoteFileList = remoteFileListList.item( i );
            if ( remoteFileList != null && remoteFileList.getNodeType() == Node.ELEMENT_NODE &&
                 remoteFileList.getNodeName().equals( "remotefile" ) )
            {
                phex.xml.XMLRemoteFile obj = XMLRemoteFileXMLCodec.decodeXML( (Element) remoteFileList );
                instance.addXMLRemoteFile( obj );
            }
        }

        return instance;
    }

    /**
     * This method is here to be more performent. It can be inlined
     * during optimized compilation.
     */
    private static String getText( Node node )
    {
        if (node == null)
        {
            return null;
        }
        StringBuffer strBuffer = new StringBuffer();
        NodeList nodeList = node.getChildNodes();
        int length = nodeList.getLength();
        for (int i = 0; i < length; i++)
        {
            Node subNode = nodeList.item(i);
            int type = subNode.getNodeType();
            if (type == Node.TEXT_NODE)
            {
                strBuffer.append(subNode.getNodeValue());
            }
            else if (type == Node.ENTITY_REFERENCE_NODE)
            {
                // The content is in the TEXT node under it
                strBuffer.append( getText( subNode ) );
            }
        }
        return strBuffer.toString();
    }

}
