/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Gregor Koukkoullis ( phex@kouk.de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex.xml;

import org.w3c.dom.*;
import javax.xml.parsers.*;
import org.apache.crimson.tree.*;
//import com.sun.xml.tree.*;
import java.util.*;
import java.io.*;
import java.lang.reflect.*;

// Generated by xgen Code Generator from Gregor Koukkoullis
// DO NOT edit this class !
public abstract class XMLDownloadListXMLCodec
{
    public static XmlDocument encodeXML(XMLDownloadList object )
    {
        XmlDocument doc = XMLBuilder.createNewDocument();
        encodeXML( object, doc, doc );
        return doc;
    }

    public static void encodeXML(XMLDownloadList object, Node parentNode, Document doc )
    {
        Element topElem = doc.createElement( "downloadlist" );
        parentNode.appendChild( topElem );

        Iterator downloadfileList = object.createXMLDownloadFileIterator();
        if ( downloadfileList.hasNext() )
        {
            phex.xml.XMLDownloadFile obj;
            while ( downloadfileList.hasNext() )
            {
                obj = (phex.xml.XMLDownloadFile) downloadfileList.next();
                XMLDownloadFileXMLCodec.encodeXML( obj, topElem, doc );
            }
        }

    }

    public static XMLDownloadList decodeXML( Element root )
    {
        // create new instance
        XMLDownloadList instance = new XMLDownloadList();

        NodeList downloadfileListList = root.getChildNodes();
        int lengthdownloadfileList = downloadfileListList.getLength();
        for (int i = 0; i < lengthdownloadfileList; i++ )
        {
            Node downloadfileList = downloadfileListList.item( i );
            if ( downloadfileList != null && downloadfileList.getNodeType() == Node.ELEMENT_NODE &&
                 downloadfileList.getNodeName().equals( "downloadfile" ) )
            {
                phex.xml.XMLDownloadFile obj = XMLDownloadFileXMLCodec.decodeXML( (Element) downloadfileList );
                instance.addXMLDownloadFile( obj );
            }
        }

        return instance;
    }

    /**
     * This method is here to be more performent. It can be inlined
     * during optimized compilation.
     */
    private static String getText( Node node )
    {
        if (node == null)
        {
            return null;
        }
        StringBuffer strBuffer = new StringBuffer();
        NodeList nodeList = node.getChildNodes();
        int length = nodeList.getLength();
        for (int i = 0; i < length; i++)
        {
            Node subNode = nodeList.item(i);
            int type = subNode.getNodeType();
            if (type == Node.TEXT_NODE)
            {
                strBuffer.append(subNode.getNodeValue());
            }
            else if (type == Node.ENTITY_REFERENCE_NODE)
            {
                // The content is in the TEXT node under it
                strBuffer.append( getText( subNode ) );
            }
        }
        return strBuffer.toString();
    }

}
