/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Gregor Koukkoullis ( phex@kouk.de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex.xml;

import org.w3c.dom.*;
import javax.xml.parsers.*;
import org.apache.crimson.tree.*;
//import com.sun.xml.tree.*;
import java.util.*;
import java.io.*;
import java.lang.reflect.*;

// Generated by xgen Code Generator from Gregor Koukkoullis
// DO NOT edit this class !
public abstract class XMLRemoteFileXMLCodec
{
    public static XmlDocument encodeXML(XMLRemoteFile object )
    {
        XmlDocument doc = XMLBuilder.createNewDocument();
        encodeXML( object, doc, doc );
        return doc;
    }

    public static void encodeXML(XMLRemoteFile object, Node parentNode, Document doc )
    {
        Element topElem = doc.createElement( "remotefile" );
        parentNode.appendChild( topElem );

        Object guid = object.getGuid();
        if ( guid != null )
        {
            String s = guid.toString();
            if ( s.length() > 0 )
            {
                Element guidElm = doc.createElement( "guid" );
                guidElm.appendChild( doc.createTextNode( s ) );
                topElem.appendChild( guidElm );
            }
        }

        Element fileIndexElm = doc.createElement( "fileindex" );
        fileIndexElm.appendChild( doc.createTextNode( String.valueOf( object.getFileIndex() ) ) );
        topElem.appendChild( fileIndexElm );

        Object fileName = object.getFileName();
        if ( fileName != null )
        {
            String s = fileName.toString();
            if ( s.length() > 0 )
            {
                Element fileNameElm = doc.createElement( "filename" );
                fileNameElm.appendChild( doc.createTextNode( s ) );
                topElem.appendChild( fileNameElm );
            }
        }

        Element fileSizeElm = doc.createElement( "filesize" );
        fileSizeElm.appendChild( doc.createTextNode( String.valueOf( object.getFileSize() ) ) );
        topElem.appendChild( fileSizeElm );

        Object remoteHost = object.getRemoteHost();
        if ( remoteHost != null )
        {
            String s = remoteHost.toString();
            if ( s.length() > 0 )
            {
                Element remoteHostElm = doc.createElement( "remotehost" );
                remoteHostElm.appendChild( doc.createTextNode( s ) );
                topElem.appendChild( remoteHostElm );
            }
        }

        Element speedElm = doc.createElement( "speed" );
        speedElm.appendChild( doc.createTextNode( String.valueOf( object.getSpeed() ) ) );
        topElem.appendChild( speedElm );

    }

    public static XMLRemoteFile decodeXML( Element root )
    {
        // create new instance
        XMLRemoteFile instance = new XMLRemoteFile();

        NodeList guidList = root.getChildNodes();
        int lengthguid = guidList.getLength();
        for (int i = 0; i < lengthguid; i++ )
        {
            Node guid = guidList.item( i );
            if ( guid != null && guid.getNodeType() == Node.ELEMENT_NODE &&
                 guid.getNodeName().equals( "guid" ) )
            {
                String guidValue = getText( (Element)guid);
                instance.setGuid( guidValue );
                break;
            }
        }

        NodeList fileIndexList = root.getChildNodes();
        int lengthfileIndex = fileIndexList.getLength();
        for (int i = 0; i < lengthfileIndex; i++ )
        {
            Node fileIndex = fileIndexList.item( i );
            if ( fileIndex != null && fileIndex.getNodeType() == Node.ELEMENT_NODE &&
                 fileIndex.getNodeName().equals( "fileindex" ) )
            {
                String fileIndexValue = getText( (Element)fileIndex);
                instance.setFileIndex( Integer.parseInt( fileIndexValue ) );
                break;
            }
        }

        NodeList fileNameList = root.getChildNodes();
        int lengthfileName = fileNameList.getLength();
        for (int i = 0; i < lengthfileName; i++ )
        {
            Node fileName = fileNameList.item( i );
            if ( fileName != null && fileName.getNodeType() == Node.ELEMENT_NODE &&
                 fileName.getNodeName().equals( "filename" ) )
            {
                String fileNameValue = getText( (Element)fileName);
                instance.setFileName( fileNameValue );
                break;
            }
        }

        NodeList fileSizeList = root.getChildNodes();
        int lengthfileSize = fileSizeList.getLength();
        for (int i = 0; i < lengthfileSize; i++ )
        {
            Node fileSize = fileSizeList.item( i );
            if ( fileSize != null && fileSize.getNodeType() == Node.ELEMENT_NODE &&
                 fileSize.getNodeName().equals( "filesize" ) )
            {
                String fileSizeValue = getText( (Element)fileSize);
                instance.setFileSize( Long.parseLong( fileSizeValue ) );
                break;
            }
        }

        NodeList remoteHostList = root.getChildNodes();
        int lengthremoteHost = remoteHostList.getLength();
        for (int i = 0; i < lengthremoteHost; i++ )
        {
            Node remoteHost = remoteHostList.item( i );
            if ( remoteHost != null && remoteHost.getNodeType() == Node.ELEMENT_NODE &&
                 remoteHost.getNodeName().equals( "remotehost" ) )
            {
                String remoteHostValue = getText( (Element)remoteHost);
                instance.setRemoteHost( remoteHostValue );
                break;
            }
        }

        NodeList speedList = root.getChildNodes();
        int lengthspeed = speedList.getLength();
        for (int i = 0; i < lengthspeed; i++ )
        {
            Node speed = speedList.item( i );
            if ( speed != null && speed.getNodeType() == Node.ELEMENT_NODE &&
                 speed.getNodeName().equals( "speed" ) )
            {
                String speedValue = getText( (Element)speed);
                instance.setSpeed( Integer.parseInt( speedValue ) );
                break;
            }
        }

        return instance;
    }

    /**
     * This method is here to be more performent. It can be inlined
     * during optimized compilation.
     */
    private static String getText( Node node )
    {
        if (node == null)
        {
            return null;
        }
        StringBuffer strBuffer = new StringBuffer();
        NodeList nodeList = node.getChildNodes();
        int length = nodeList.getLength();
        for (int i = 0; i < length; i++)
        {
            Node subNode = nodeList.item(i);
            int type = subNode.getNodeType();
            if (type == Node.TEXT_NODE)
            {
                strBuffer.append(subNode.getNodeValue());
            }
            else if (type == Node.ENTITY_REFERENCE_NODE)
            {
                // The content is in the TEXT node under it
                strBuffer.append( getText( subNode ) );
            }
        }
        return strBuffer.toString();
    }

}
