

/*

 *  PHEX - The pure-java Gnutella-servent.

 *  Copyright (C) 2000 William W. Wong

 *  williamw@jps.net

 *

 *  This program is free software; you can redistribute it and/or modify

 *  it under the terms of the GNU General Public License as published by

 *  the Free Software Foundation; either version 2 of the License, or

 *  (at your option) any later version.

 *

 *  This program is distributed in the hope that it will be useful,

 *  but WITHOUT ANY WARRANTY; without even the implied warranty of

 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

 *  GNU General Public License for more details.

 *

 *  You should have received a copy of the GNU General Public License

 *  along with this program; if not, write to the Free Software

 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */





package phex;





import java.net.*;

import java.util.*;







public class HttpContentRange extends HttpRange

{

	protected HttpContentRange()

	{

		// disable

	}





	public HttpContentRange(int entitySize)

	{

		super(entitySize);

		mEntitySize = entitySize;

	}





	public boolean deserialize(String rangeValue)

	{

		// Content-range: bytes 0-1000/9000

		try

		{

			rangeValue = rangeValue.toLowerCase().trim();



			if (!rangeValue.startsWith("bytes "))

				return false;



			rangeValue = rangeValue.substring(6);

			StringTokenizer	specs = new StringTokenizer(rangeValue, "/");

			String			spec = specs.nextToken();

			

			StringTokenizer	values = new StringTokenizer(spec, "-");

			mFirstPos[mCount] = Integer.parseInt(values.nextToken());

			mLastPos[mCount] = Integer.parseInt(values.nextToken());

			mCount++;



			mEntitySize = Integer.parseInt(specs.nextToken());

		}

		catch (Exception e)

		{

			mCount = 0;

			return false;

		}



		return true;

	}







	public String serialize()

	{

		StringBuffer	buf = new StringBuffer();



		buf.append("Content-range: bytes ");

		for (int i = 0; i < mCount; i++)

		{

			buf.append(mFirstPos[i]);

			buf.append("-");

			buf.append(mLastPos[i]);

			buf.append("/");

			buf.append(mEntitySize);

		}



		return buf.toString();

	}





	public void setSpec(int first, int last)

	{

		mFirstPos[0] = first;

		mLastPos[0] = last;

		mCount = 1;

	}





	public int getFirstPos()

	{

		return mFirstPos[0];

	}





	public int getLastPos()

	{

		return mLastPos[0];

	}





	// Unit test

	public static void main(String[] args)

	{

		HttpContentRange	range = new HttpContentRange(1000);



		range.deserialize(args[0]);



		System.out.println(range);

		

	}





}



