
/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2000 William W. Wong
 *  williamw@jps.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package phex;


import java.net.*;
import java.util.*;



public class HttpRange
{
	protected int		mCount = 0;
	protected int		mMaxSize = 4;
	protected int[]		mFirstPos = new int[mMaxSize];
	protected int[]		mLastPos = new int[mMaxSize];
	protected int		mEntitySize = 0;



	protected HttpRange()
	{
		// disable
	}


	public HttpRange(int entitySize)
	{
		mEntitySize = entitySize;
	}


	public boolean deserialize(String rangeValue)
	{
		// Range: bytes=0-1000,-500,99-
		try
		{
			rangeValue = rangeValue.toLowerCase().trim();

			if (!rangeValue.startsWith("bytes"))
				return false;

			rangeValue = rangeValue.substring(6);
			StringTokenizer	specs = new StringTokenizer(rangeValue, ",");
			while (specs.hasMoreTokens())
			{
				String			spec = specs.nextToken();
				StringTokenizer	values = new StringTokenizer(spec, "-", true);
				String			part;
				
				part = values.nextToken();
				if (part.equals("-"))
				{
					// -M
					int		offsetFromEnd = Integer.parseInt(values.nextToken());
					mFirstPos[mCount] = mEntitySize - offsetFromEnd;
					mLastPos[mCount] = mEntitySize - 1;
				}
				else
				{
					mFirstPos[mCount] = Integer.parseInt(part);
					values.nextToken();				// skip "-"
					if (values.hasMoreTokens())
					{
						// N-M
						mLastPos[mCount] = Integer.parseInt(values.nextToken());
					}
					else
					{
						// N-
						mLastPos[mCount] = mEntitySize - 1;
					}
				}
				mCount++;
			}
		}
		catch (Exception e)
		{
			mCount = 0;
			return false;
		}

		return true;
	}



	public String serialize()
	{
		StringBuffer	buf = new StringBuffer();

		buf.append("Range: bytes=");
		for (int i = 0; i < mCount; i++)
		{
			if (i > 0)
				buf.append(",");
			if (mFirstPos[i] >= 0)
				buf.append(mFirstPos[i]);
			buf.append("-");
			if (mLastPos[i] >= 0)
				buf.append(mLastPos[i]);
		}

		return buf.toString();
	}


	public void setSpec(int index, int first, int last)
	{
		mFirstPos[index] = first;
		mLastPos[index] = last;
	}


	public int addSpec(int first, int last)
	{
		ensureSize(mCount + 1);
		mFirstPos[mCount] = first;
		mLastPos[mCount] = last;
		mCount++;

		return mCount-1;
	}


	public int getSpecCount()
	{
		return mCount;
	}


	public void setSpecCount(int count)
	{
		mCount = count;
		ensureSize(count);
	}


	public int getFirstPos(int index)
	{
		return mFirstPos[index];
	}


	public int getLastPos(int index)
	{
		return mLastPos[index];
	}


	public int getFirstPos()
	{
		return mFirstPos[0];
	}


	public int getLastPos()
	{
		return mLastPos[0];
	}


	public int getEntitySize()
	{
		return mEntitySize;
	}


	public void setEntitySize(int size)
	{
		mEntitySize = size;
	}


	public String toString()
	{
		return serialize();
	}


	protected void ensureSize(int newSize)
	{
		if (mMaxSize < newSize)
		{
			int[]	newFirst = new int[newSize + 4];
			int[]	newLast = new int[newSize + 4];
			System.arraycopy(mFirstPos, 0, newFirst, 0, mCount);
			System.arraycopy(mLastPos, 0, newLast, 0, mCount);
			mFirstPos = newFirst;
			mLastPos = newLast;
			mMaxSize = newSize + 4;
		}
	}



	// Unit test
	public static void main(String[] args)
	{
		HttpRange	range = new HttpRange(1000);

		range.deserialize(args[0]);

		System.out.println(range);
		
	}


}

