
/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Gregor Koukkoullis ( phex@kouk.de )
 *  Copyright (C) 2000 William W. Wong
 *  williamw@jps.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package phex;

import java.io.*;
import java.net.*;
import java.util.*;
import phex.config.*;
import phex.download.*;
import phex.host.*;
import phex.msg.*;
import phex.share.*;
import phex.query.QueryManager;
import phex.common.TransferRateService;
import phex.utils.StatisticTracker;

public class JobsRunner implements Runnable
{
    private boolean				mRequestToDie = false;
    private boolean				mRunning = false;
    private boolean				mShutdownCompleted = false;
    private HostManager			mHostMgr = ServiceManager.getHostManager();
    private NetworkManager		mNetworkMgr = ServiceManager.getNetworkManager();
    private MsgManager			mMsgManager = ServiceManager.getMsgManager();
    private DownloadManager		mDownloadMgr = ServiceManager.getDownloadManager();
    private ShareManager		mShareMgr = ServiceManager.getShareManager();
    private StatisticTracker statisticTracker;
    private TransferRateService transferRateService;
    private boolean				mInitScan = false;

    JobsRunner()
    {
        statisticTracker = ServiceManager.getStatisticTracker();
        transferRateService = ServiceManager.getTransferRateService();
    }


    public synchronized void startup()
    {
        if (mRunning)
            return;

        ServiceManager.log("Background jobs runner starting...");

        mRequestToDie = false;
        mRunning = true;

        new Thread(this, "JobsRunner-" + Integer.toHexString(hashCode())).start();
    }

    public boolean getRunning()
    {
        return mRunning;
    }

    public synchronized void shutdown(boolean waitForCompleted)
    {
        // Already dead or been requested to die.
        if (mRequestToDie)
        {
            return;
        }

        ServiceManager.log("Background jobs runner shutting down...");

        // Set flag to die.
        mShutdownCompleted = false;
        mRequestToDie = true;

        if (waitForCompleted)
        {
            // Wait until the thread is dead.
            while (!mShutdownCompleted)
            {
                try
                {
                    wait();
                }
                catch (InterruptedException e)
                {
                    break;
                }
            }
        }
    }


    public void run()
    {
        ServiceManager.log("Background jobs runner started.");

        MainFrame	mainFrame = ServiceManager.getManager().getMainFrame();
        int sleepAmount = 1000;
        int counter = 0;
        QueryManager queryMgr = ServiceManager.getQueryManager();

        while (true)
        {
            try
            {
                // Sleep for a while.
                try
                {
                    Thread.sleep(sleepAmount);
                }
                catch (Exception e)
                {
                }

                // See if I has been asked to die.
                if (mRequestToDie)
                {
                    break;
                }

                mMsgManager.pingNeighbors();
                mHostMgr.periodicallyCheckHosts();
                ServiceManager.getLazyEventQueue().fireLazyEvents();

                // Do the routine jobs.
                if (counter % 2 == 0)
                {
                    mHostMgr.cleanupConnectedHosts();
                    mHostMgr.cleanupNetworkHosts();
                    int hostCount = mHostMgr.getConnectedHostCount();
                    if ( hostCount < ServiceManager.sCfg.mNetMinConn
                        && mNetworkMgr.getJoined())
                    {
                        int countMissing = ServiceManager.sCfg.mNetMaxConnection
                            - mHostMgr.getNetworkHostCount();
                        for ( int i = countMissing; i > 0; i-- )
                        {
                            mHostMgr.autoConnectToNextCaughtHost();
                        }
                    }
                    mDownloadMgr.retryDownloads();
                }

                if (counter % 5 == 0)
                {
                    mainFrame.getDownloadTab().removeCompletedDownloads();
                    if (ServiceManager.sCfg.mUploadAutoRemoveCompleted)
                    {
                        mShareMgr.getUploadFileContainer().cleanUploadFileList();
                    }
                    queryMgr.stopExpiredSearches();
                    queryMgr.getResearchService().startResearchSequence();
                }

                if ( counter % 10 == 0 )
                {
                    statisticTracker.newRateSamplePeriod();
                    transferRateService.setTransferRateTimestamp();
                }

                if ( counter % 60 == 0 )
                {
                    mHostMgr.saveHostsContainer();
                }

                if (!mInitScan)
                {
                    // Scan the file to share once at initialization time.
                    mShareMgr.getFileAdministration().rescan();
                    mInitScan = true;
                }
                counter++;
            }
            catch (Exception e)
            {
                // Catch exception and continue.  Don't kill the thread.
                e.printStackTrace();
            }
        }

        shutdownCompleted();
    }

    private synchronized void shutdownCompleted()
    {
        mRunning = false;
        ServiceManager.log("Background jobs runner stopped.");
        mShutdownCompleted = true;
        notifyAll();
    }

}


