/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Konrad Haenel ( alterego1@gmx.at )
 *                     Gregor Koukkoullis ( phex@kouk.de )
 *  Copyright (C) 2000 William W. Wong ( williamw@jps.net )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex;

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.datatransfer.*;
import java.lang.reflect.*;
import java.io.*;
import java.net.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;

import phex.msg.MsgManager;
import phex.utils.StatisticTracker;
import phex.utils.StrUtil;
import phex.utils.BrowserLauncher;
import phex.utils.URLUtil;
import phex.utils.Localizer;
import phex.host.HostManager;
import phex.share.UploadFileContainer;
import phex.interfaces.IDataChangedListener;
import phex.event.UploadFilesChangeListener;
import phex.event.NetworkHostsChangeListener;
import phex.download.DownloadManager;
import phex.download.RemoteFile;
import phex.update.UpdateChecker;
import phex.gui.tabs.SearchTab;
import phex.gui.tabs.ShareTab;
import phex.gui.tabs.NetworkTab;
import phex.gui.tabs.MonitorTab;
import phex.gui.tabs.DownloadTab;
import phex.gui.common.GUIUtils;
import phex.gui.dialogs.UpdateNotificationDialog;

public class MainFrame extends BaseFrame
{
    public static int DOWNLOAD_TAB = 3;
    private MsgManager			mMsgManager = ServiceManager.getMsgManager();
    private DownloadManager		mDownloadMgr = ServiceManager.getDownloadManager();
    private StatisticTracker statTracker = ServiceManager.getStatisticTracker();
    private HostManager			mHostMgr;
    private NetworkManager		mNetworkMgr;
    //private ShareManager		mShareMgr;
    private JLabel				mStatusLabel;
    private JTabbedPane			mTabs;
    private JPanel				mUpload;
    private javax.swing.Timer	mRefresher;
    private boolean				mInRefreshHandler = false;
    private SignalPanel			mSignalPanel;

    private UploadFileContainer uploadContainer;

    private NetworkTab networkTab;
    private SearchTab searchTab;
    private MonitorTab monitorTab;
    private DownloadTab downloadTab;
    private ShareTab shareTab;

    private MainFrame()
    {
        // disable
    }


    public MainFrame(Applet applet, SplashWindow splash)
    {
        super("Main", applet);

        ServiceManager.getManager().setMainFrame(this);
        mHostMgr = ServiceManager.getHostManager();
        mNetworkMgr = ServiceManager.getNetworkManager();
        uploadContainer = ServiceManager.getShareManager().getUploadFileContainer();

        ServiceManager.sCfg.save();

        setFonts();
        setupComponents();
/*
        Hashtable ht = UIManager.getDefaults();
        Enumeration enum = ht.keys();
        while (enum.hasMoreElements())
        {
            Object	key = enum.nextElement();
            System.out.println(key + "=" + ht.get(key));
        }
*/
        ServiceManager.getListener().setHostChangedListener( networkTab );
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowHandler());

        pack();
        centerAndSizeWindow(this, 7, 8);
        refreshAllActions();
//		updateIrcInfoLabel();
        resetLookAndFeel();
        setTitle();

        splash.dispose();
        setVisible(true);

        try
        {
            ServiceManager.getListener().startup();
        }
        catch (IOException e)
        {
            e.printStackTrace();
        }
/*
        try
        {
            ServiceManager.getIdentd().startup();
        }
        catch (IOException e)
        {
            e.printStackTrace();
        }
*/
        ServiceManager.getNetworkManager().init();
        mDownloadMgr.init();

        mRefresher = new javax.swing.Timer(1000, new RefreshHandler());
        mRefresher.start();

        ServiceManager.getManager().startJobsRunner();
        checkForUpdates();
    }


    private void setupComponents()
    {
        JLabel		label;

        mTabs = new JTabbedPane();
        mTabs.setMinimumSize(new Dimension(50, 50));
//		mTabs.setPreferredSize(new Dimension(780, 440));

        //
        // Net Tab
        //
        networkTab = new NetworkTab( this );
        networkTab.initComponent();
        mTabs.add( " Gnutella Net ", networkTab );

        //
        // Search Tab
        //
        searchTab = new SearchTab( this );
        searchTab.initComponent();
        mTabs.add( " Search ", searchTab );

        //
        //  Monitor Tab
        //
        monitorTab = new MonitorTab( this );
        monitorTab.initComponent();
        mTabs.add( " Monitor Search ", monitorTab );

        //
        //  Download Tab
        //
        downloadTab = new DownloadTab( this );
        downloadTab.initComponent();
        mTabs.add( " Download ", downloadTab );

        //
        //  Upload Tab
        //

        shareTab = new ShareTab( this );
        shareTab.initComponent();
        mTabs.add(" Share ", shareTab );


        // Status Bar
        JPanel	statusBar = new JPanel(new BorderLayout());
        statusBar.setBorder(
                BorderFactory.createCompoundBorder(
                    BorderFactory.createLoweredBevelBorder(),
                    BorderFactory.createEmptyBorder(2, 2, 2, 2)));

        mSignalPanel = new SignalPanel();
        mStatusLabel = new JLabel();
        statusBar.add(BorderLayout.WEST, mSignalPanel);
        statusBar.add(BorderLayout.CENTER, mStatusLabel);


        getContentPane().add(BorderLayout.CENTER, mTabs);
        getContentPane().add(BorderLayout.SOUTH, statusBar);

        StatusChangedListener statusListener = new StatusChangedListener();
        statTracker.addStatusChangedListener(statusListener);
        mDownloadMgr.addStatusChangedListener(statusListener);

        // listeners for status bar updates
        mHostMgr.addNetworkHostsChangeListener( new NetworkHostsListener() );
        uploadContainer.addUploadFilesChangeListener( new UploadFilesListener() );
    }

    public void setTitle()
    {
        StringBuffer buffer = new StringBuffer( StrUtil.getAppNameVersion() );

        if (mNetworkMgr.getJoined())
        {
            buffer.append(" - ");
            buffer.append( ServiceManager.sCfg.mCurrentNetwork );
        }

        if (ServiceManager.sCfg.mProxyUse)
        {
            buffer.append( "  (via Proxy Server)" );
        }
        super.setTitle( buffer.toString() );
    }

    public void selectTab(int index)
    {
        mTabs.setSelectedIndex(index);
    }


    public boolean isNetTabSelected()
    {
        return (mTabs != null && mTabs.getSelectedIndex() == 0);
    }


    public boolean isSearchTabSelected()
    {
        return (mTabs != null && mTabs.getSelectedIndex() == 1);
    }


    public boolean isMonitorTabSelected()
    {
        return (mTabs != null && mTabs.getSelectedIndex() == 2);
    }

    public boolean isDownloadTabSelected()
    {
        return (mTabs != null && mTabs.getSelectedIndex() == DOWNLOAD_TAB );
    }

    public boolean isUploadTabSelected()
    {
        return (mTabs != null && mTabs.getSelectedIndex() == 4);
    }

    public void search()
    {
        searchTab.search();
    }

    public phex.query.Search getSelectedSearchResult()
    {
        return searchTab.getSelectedSearchResult();
    }

    public void setSelectedTab( int index )
    {
        mTabs.setSelectedIndex( index );
    }

    public void launchBrowserOnHost()
    {
        RemoteFile	rfile;

        if (isSearchTabSelected())
        {
            rfile = searchTab.getSelectedRemoteFile();
        }
        else if (isMonitorTabSelected())
        {
            rfile = monitorTab.getSelectedRemoteFile();
        }
        else
        {
            return;
        }

        String url = StrUtil.parseURLHostPort(rfile.getURL());
        if (url == null)
            return;

        try
        {
            BrowserLauncher.openURL( url );
        }
        catch (Exception e)
        {
            JOptionPane.showMessageDialog(this, "Failed to launch browser  " + e.getMessage(), "Can't Launch Browser", JOptionPane.ERROR_MESSAGE);
        }
    }


    public void launchBrowserOnURL()
    {
        RemoteFile	rfile;

        if (isSearchTabSelected())
        {
            rfile = searchTab.getSelectedRemoteFile();
        }
        else if (isMonitorTabSelected())
        {
            rfile = monitorTab.getSelectedRemoteFile();
        }
        else
        {
            return;
        }

        String		url = URLUtil.encodeURL(rfile.getURL());
        try
        {
            BrowserLauncher.openURL( url );
        }
        catch (Exception e)
        {
            JOptionPane.showMessageDialog(this, "Failed to launch browser  " + e.getMessage(), "Can't Launch Browser", JOptionPane.ERROR_MESSAGE);
        }
    }

    public ShareTab getShareTab()
    {
        return shareTab;
    }

    public NetworkTab getNetworkTab()
    {
        return networkTab;
    }

    public SearchTab getSearchTab()
    {
        return searchTab;
    }

    public MonitorTab getMonitorTab()
    {
        return monitorTab;
    }

    public DownloadTab getDownloadTab()
    {
        return downloadTab;
    }

    public int getResultSelectedCount()
    {
        return searchTab.getResultSelectedCount();
    }

    private void checkForUpdates()
    {
        UpdateChecker checker = new UpdateChecker( new phex.event.UpdateNotificationListener()
            {
                public void updateNotification( UpdateChecker updateChecker )
                {
                    UpdateNotificationDialog dialog =
                        new UpdateNotificationDialog( updateChecker );
                    dialog.show();
                }
            });
        checker.checkForUpdate();
    }

    // Go through freaking hoops to work around the table selection bug in JDK 1.3.
    private void fireTableChanged(JTable table, AbstractTableModel model)
    {
        // Save the table selection before firing the table changed event.
        int		rowCount = table.getSelectedRowCount();
        int[]	rows = table.getSelectedRows();

        // Fire the event
        model.fireTableDataChanged();

        // Restore the table selection.
        if (rowCount > 0)
        {
            for (int i = 0; i < rows.length; i++)
            {
                if (rows[i] < table.getRowCount())
                    table.addRowSelectionInterval(rows[i], rows[i]);
            }
        }
    }



    /**
     * Class to handle the WindowClosing event on the main frame.
     *
     */
    private class WindowHandler extends WindowAdapter
    {
        /**
         * Just delegate to the ActionFileExit acion.
         */
        public void windowClosing(WindowEvent e)
        {
            doAction(MainFrame.this, "ActionFileExit");
        }
    }

    private class ChangeHandler implements ChangeListener
    {
        public void stateChanged(ChangeEvent e)
        {
            refreshAllActions();
        }
    }

    private class UploadFilesListener
        implements UploadFilesChangeListener
    {
        public void uploadFileChanged( final int position )
        {
        }

        public void uploadFileAdded( final int position )
        {
            updateStatusBar();
        }

        public void uploadFileRemoved( final int position )
        {
            updateStatusBar();
        }
    }

    private class NetworkHostsListener
        implements NetworkHostsChangeListener
    {
        public void networkHostChanged( int position )
        {
        }

        public void networkHostAdded( int position )
        {
            updateStatusBar();
            updateSignalPanel();
        }

        public void networkHostRemoved( int position )
        {
            updateStatusBar();
            updateSignalPanel();
        }

        // TODO nice would be to have a NetworkHostChangeEvent
        // that contains the count...
        // TODO make this nicer together with updateStatusBar
        private void updateSignalPanel()
        {
            int count = mHostMgr.getNetworkHostCount();
            if ( count > 0 )
            {
                mSignalPanel.setState( SignalPanel.sStateGreen );
            }
            else
            {
                mSignalPanel.setState( SignalPanel.sStateGrey );
            }
        }
    }

    private class StatusChangedListener implements IDataChangedListener
    {
        public void dataChanged(Object source)
        {
            updateStatusBar();
        }
    }

    private void updateStatusBar()
    {
        // invoke update in event dispatcher
        // TODO make this nicer together with updateSignalPanel
        SwingUtilities.invokeLater(
        new Runnable()
        {
            public void run()
            {
                StringBuffer	buf = new StringBuffer();
                buf.append("  Connected Hosts: ");
                buf.append( mHostMgr.getConnectedHostCount());
                buf.append("    Uploads: ");
                buf.append( uploadContainer.getUploadFileCount() );
                buf.append(", ");
                buf.append( statTracker.getStatUploadCount());
                buf.append("    Downloads: ");
                // TODO move to statistic tracker
                buf.append( mDownloadMgr.getDownloadingCount());
                buf.append(", ");
                buf.append( statTracker.getStatDownloadCount());

                mStatusLabel.setText(buf.toString());
            }
        });
    }

    private class RefreshHandler implements ActionListener
    {
        public void actionPerformed(ActionEvent e)
        {
            mInRefreshHandler = true;
            networkTab.refresh();
            mInRefreshHandler = false;
        }
    }
}
