/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2000 William W. Wong
 *  williamw@jps.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package phex;


import java.util.*;
import java.io.*;

import phex.config.*;
import phex.host.*;
import phex.msg.*;


public class NetworkManager
{
    private static final String sRequestSignature = "GNUTELLA CONNECT";
    private static final String sRequestVersion = "/0.4";

    private ServiceManager		mManager;
    private boolean				mJoined;

    NetworkManager()
    {
        mManager = ServiceManager.getManager();
        mJoined = ServiceManager.sCfg.mAutoJoin;
    }

    public void init()
    {
        if (getJoined())
        {
            HostManager hostMgr =  mManager.getHostManager();
            hostMgr.initializeCaughtHosts();
        }
    }


    public synchronized void joinNetwork()
    {
        HostManager hostMgr =  mManager.getHostManager();
        hostMgr.initializeCaughtHosts();

        // TODO this is all dirty there should be no data -> gui interaction
        mManager.getMainFrame().getNetworkTab().updateStat();
        mJoined = true;
        mManager.getMainFrame().setTitle();
        mManager.getMainFrame().refreshAllActions();
    }

    public synchronized void leaveNetwork()
    {
        mJoined = false;
        MainFrame frame = ServiceManager.getManager().getMainFrame();
        frame.setTitle();
        frame.refreshAllActions();
        ServiceManager.getHostManager().removeAllNetworkHosts();

        ServiceManager.getQueryManager().getSearchContainer().stopAllSearches();
    }


    public boolean getJoined()
    {
        return mJoined;
    }


    public String getGreeting()
    {
        if (ServiceManager.sCfg.mCurrentNetwork.equals(ServiceManager.sCfg.sGeneralNetwork))
        {
            return sRequestSignature;
        }
        else
        {
            return "GNUTELLA PCONNECT " + ServiceManager.sCfg.mCurrentNetwork;
        }
    }

    public String getFullGreeting()
    {
        return getGreeting() + sRequestVersion;
    }
}