/*

 *  PHEX - The pure-java Gnutella-servent.

 *  Copyright (C) 2000 William W. Wong

 *  williamw@jps.net

 *

 *  This program is free software; you can redistribute it and/or modify

 *  it under the terms of the GNU General Public License as published by

 *  the Free Software Foundation; either version 2 of the License, or

 *  (at your option) any later version.

 *

 *  This program is distributed in the hope that it will be useful,

 *  but WITHOUT ANY WARRANTY; without even the implied warranty of

 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

 *  GNU General Public License for more details.

 *

 *  You should have received a copy of the GNU General Public License

 *  along with this program; if not, write to the Free Software

 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */





package phex;





import javax.swing.*;

import java.awt.*;

import java.awt.event.*;





public class SignalPanel extends JPanel

{

	public static final int	sStateGrey = 0;

	public static final int	sStateYellow = 1;

	public static final int	sStateGreen = 2;

	

	private Image			mGreenDot;

	private Image			mGreyDot;

	private Dimension		mSize;

	private int				mState = 0;





	public SignalPanel()

	{

		ImageIcon		icon;



		icon = Res.getIcon("Signal.Green");

		mGreenDot = icon.getImage();

		icon = Res.getIcon("Signal.Grey");

		mGreyDot = icon.getImage();



		mSize = new Dimension(mGreenDot.getWidth(null), mGreenDot.getHeight(null));

	}





	public void setState(int state)

	{

		mState = state;

		repaint();

	}





	public Dimension getPreferredSize()

	{

		return mSize;

	}





	public Dimension getMinimumSize()

	{

		return mSize;

	}







	public void update(Graphics g)

	{

		// Paint directly to avoid clearing the screen.

		paint(g);

	}





	public void paint(Graphics g)

	{

		super.paint(g);



		switch (mState)

		{

			case sStateGrey:

				g.drawImage(mGreyDot, -1, 0, null);

				break;



			case sStateYellow:

//				g.drawImage(mYellowDot, -1, 0, null);

				break;



			case sStateGreen:

				g.drawImage(mGreenDot, -1, 0, null);

				break;

		}



//		g.setColor(Color.darkGray);

//		g.drawRect(0, 0, size.width-1, size.height-1);

	}



}



