

/*

 *  PHEX - The pure-java Gnutella-servent.

 *  Copyright (C) 2000 William W. Wong

 *  williamw@jps.net

 *

 *  This program is free software; you can redistribute it and/or modify

 *  it under the terms of the GNU General Public License as published by

 *  the Free Software Foundation; either version 2 of the License, or

 *  (at your option) any later version.

 *

 *  This program is distributed in the hope that it will be useful,

 *  but WITHOUT ANY WARRANTY; without even the implied warranty of

 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

 *  GNU General Public License for more details.

 *

 *  You should have received a copy of the GNU General Public License

 *  along with this program; if not, write to the Free Software

 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */





package phex.actions.base;





import java.awt.event.*;

import java.util.*;

import java.net.*;

import javax.swing.*;

import javax.swing.tree.*;



import phex.*;

import phex.interfaces.*;







public abstract class ActionBase extends AbstractAction

{

	protected Vector		mRefreshComponents;

	protected BaseFrame		mFrame;





	/**

	*	Default constructor.  Enabled to allow package structure.

	*/

	public ActionBase()

	{

		// disable

	}





	/**

	*	Initialize an action object.  Called by subclass's constructor.

	*	

	*	@param frame	The BaseFrame object that this action belongs to.

	*	@param label	The label of the action, used in constructing menu.

	*	@param icon		The icon of the action, used in constructing the menu

	*					item and/or the toolbar button.

	*/

	public ActionBase(BaseFrame frame, String label, Icon icon)

	{

		super(label, icon);

		mFrame = frame;

		mRefreshComponents = new Vector();

	}





	/**

	*	Add a JComponent that can invoke this action so that it can enable

	*	or disable the component.

	*

	*	@param comp		The JComponent.

	*/

	public void addRefreshComponent(JComponent comp)

	{

		mRefreshComponents.addElement(comp);

	}





	/**

	*	Enable or disable all the invoking components that this action

	*	has references.

	*

	*	@param enableFlag	true = enable, false = disable

	*/

	public void setEnabled(boolean enableFlag)

	{

		for (int i = 0; i < mRefreshComponents.size(); i++)

		{

			JComponent	comp = (JComponent)mRefreshComponents.elementAt(i);

			comp.setEnabled(enableFlag);

		}

		super.setEnabled(enableFlag);

	}





	/**

	*	Extended by subclass.  Gives each action a chance to refresh the

	*	components it's referencing.  When the BaseFrame.refreshAllActions()

	*	method is called, the refresh() method of each action is called

	*	in turn.

	*/

	abstract public void refresh();



}





