
/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2000 William W. Wong
 *  williamw@jps.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package phex.actions.transfer;


import java.awt.event.*;
import java.util.*;
import java.net.*;
import javax.swing.*;

import phex.*;
import phex.actions.base.*;


public class ActionTransferCopyURL extends ActionBase
{
    public ActionTransferCopyURL(BaseFrame frame, String label, Icon icon)
    {
        super(frame, label, icon);
    }


    public void actionPerformed( ActionEvent event )
    {
        MainFrame	frame = (MainFrame)mFrame;

        if (frame.isSearchTabSelected())
        {
            frame.getSearchTab().copyURL();
        }
        if (frame.isMonitorTabSelected())
        {
            frame.getMonitorTab().passiveCopyURL();
        }
    }


    public void refresh()
    {
        MainFrame	frame = (MainFrame)mFrame;

        if (frame.isSearchTabSelected())
        {
            setEnabled(frame.getResultSelectedCount() > 0);
            return;
        }
        if (frame.isMonitorTabSelected())
        {
            setEnabled( frame.getMonitorTab().isPassiveResultSelected());
            return;
        }

        setEnabled(false);
    }
}


